/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class ApplicationMapper
extends GenericLegacyImporter
implements LegacyImporter {
    protected static final String APPLICATION_XML_ROOT = "applications";
    protected static final String APPLICATION_XML_NODE = "application";
    private static final String APPLICATION_XML_NAME = "name";
    private static final String APPLICATION_XML_DESCRIPTION = "description";
    private static final String APPLICATION_XML_DIRECTORY_ID = "directoryId";
    private static final String APPLICATION_XML_ACTIVE = "active";
    private static final String APPLICATION_XML_REMOTE_ADDRESSES_NODE = "remoteAddresses";
    private static final String APPLICATION_XML_REMOTE_ADDRESSES_VALUE = "address";
    private static final String APPLICATION_XML_DIRECTORY_NODE = "directories";
    private static final String APPLICATION_XML_DIRECTORY_ALLOW_ALL = "allowAll";
    private static final String APPLICATION_XML_GROUPS_NODE = "groups";
    private static final String APPLICATION_XML_PERMISSIONS_NODE = "permissions";
    private static final String APPLICATION_XML_PERMISSION = "permission";
    private static final String APPLICATION_XML_PERMISSION_TYPE = "type";
    private static final String APPLICATION_XML_PERMISSION_ALLOWED = "allowed";
    public static final String OPTION_DEFAULT_PASSWORD = "password";
    private static final String APPLICATION_XML_APPLICATION_TYPE_ATTRIBUTE_NAME = "applicationType";
    private final DirectoryDAOHibernate directoryDAO;

    public ApplicationMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor);
        this.directoryDAO = directoryDAO;
    }

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element applicationRoot = (Element)root.selectSingleNode("/crowd/ applications");
        if (applicationRoot == null) {
            this.logger.error((Object)"No applications were found for importing!");
            return;
        }
        Iterator applications = applicationRoot.elementIterator();
        while (applications.hasNext()) {
            Element applicationElement = (Element)applications.next();
            ApplicationImpl application = this.getApplicationFromXml(applicationElement, importData.getOldToNewDirectoryIds());
            this.addEntityViaMerge(application);
        }
    }

    protected ApplicationImpl getApplicationFromXml(Element applicationElement, Map<Long, Long> oldToNewDirectoryIds) {
        Element groupMappingsElement;
        InternalEntityTemplate template = this.getInternalEntityTemplateFromLegacyXml(applicationElement);
        template.setId(null);
        ApplicationImpl application = new ApplicationImpl(template);
        Map<String, Set<String>> applicationAttributeValues = this.getMultiValuedAttributesMapFromXml(applicationElement);
        application.setType(this.getApplicationType(applicationAttributeValues));
        application.setDescription(applicationElement.element(APPLICATION_XML_DESCRIPTION).getText());
        application.setCredential(this.getPasswordCredentialFromXml(applicationElement));
        application.setRemoteAddresses(this.buildRemoteAddresses(applicationElement));
        Map<String, String> attributes = this.getSingleValuedAttributesMapFromXml(applicationElement);
        application.setAttributes(attributes);
        Element directoryMappingsElement = applicationElement.element(APPLICATION_XML_DIRECTORY_NODE);
        if (directoryMappingsElement != null) {
            Iterator directoryMappingsIter = directoryMappingsElement.elementIterator();
            while (directoryMappingsIter.hasNext()) {
                Element directoryMappingElement = (Element)directoryMappingsIter.next();
                Long oldDirectoryId = Long.parseLong(directoryMappingElement.attributeValue(APPLICATION_XML_DIRECTORY_ID));
                DirectoryImpl directoryReference = (DirectoryImpl)this.directoryDAO.loadReference(oldToNewDirectoryIds.get(oldDirectoryId).longValue());
                boolean allowAll = Boolean.parseBoolean(directoryMappingElement.attributeValue(APPLICATION_XML_DIRECTORY_ALLOW_ALL));
                DirectoryMapping directoryMapping = new DirectoryMapping((Application)application, (Directory)directoryReference, allowAll);
                application.getDirectoryMappings().add(directoryMapping);
            }
        }
        if ((groupMappingsElement = applicationElement.element(APPLICATION_XML_GROUPS_NODE)) != null) {
            Iterator groupMappingsIter = groupMappingsElement.elementIterator();
            while (groupMappingsIter.hasNext()) {
                Long oldDirectoryId;
                DirectoryMapping mapping;
                Element groupMappingElement = (Element)groupMappingsIter.next();
                String groupName = groupMappingElement.attributeValue(APPLICATION_XML_NAME);
                boolean activeGroupMapping = Boolean.parseBoolean(groupMappingElement.attributeValue(APPLICATION_XML_ACTIVE));
                if (!activeGroupMapping || (mapping = application.getDirectoryMapping(oldToNewDirectoryIds.get(oldDirectoryId = Long.valueOf(Long.parseLong(groupMappingElement.attributeValue(APPLICATION_XML_DIRECTORY_ID)))).longValue())) == null) continue;
                GroupMapping groupMapping = new GroupMapping(mapping, groupName);
                mapping.getAuthorisedGroups().add(groupMapping);
            }
        }
        if (applicationElement.element(APPLICATION_XML_PERMISSIONS_NODE) != null) {
            Iterator permissionsIter = applicationElement.elementIterator(APPLICATION_XML_PERMISSIONS_NODE);
            while (permissionsIter.hasNext()) {
                Element permissionsElement = (Element)permissionsIter.next();
                Long oldDirectoryId = Long.valueOf(permissionsElement.attributeValue(APPLICATION_XML_DIRECTORY_ID));
                ArrayList<OperationType> allowedOperations = new ArrayList<OperationType>();
                Iterator permIter = permissionsElement.elementIterator(APPLICATION_XML_PERMISSION);
                while (permIter.hasNext()) {
                    OperationType operationType;
                    Element permissionElement = (Element)permIter.next();
                    if (!Boolean.valueOf(permissionElement.attributeValue(APPLICATION_XML_PERMISSION_ALLOWED)).booleanValue() || (operationType = this.getOperationTypeFromLegacyPermissionName(permissionElement.attributeValue(APPLICATION_XML_PERMISSION_TYPE))) == null) continue;
                    allowedOperations.add(operationType);
                }
                application.getDirectoryMapping(oldToNewDirectoryIds.get(oldDirectoryId).longValue()).getAllowedOperations().addAll(allowedOperations);
            }
        } else {
            for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                directoryMapping.addAllowedOperations(OperationType.values());
            }
        }
        return application;
    }

    private Set<RemoteAddress> buildRemoteAddresses(Element applicationElement) {
        HashSet<RemoteAddress> addresses = new HashSet<RemoteAddress>();
        Element remoteAddressesElement = applicationElement.element(APPLICATION_XML_REMOTE_ADDRESSES_NODE);
        if (remoteAddressesElement != null && remoteAddressesElement.hasContent()) {
            Iterator iterator = remoteAddressesElement.elementIterator();
            while (iterator.hasNext()) {
                Element remoteAddressElement = (Element)iterator.next();
                boolean active = Boolean.parseBoolean(remoteAddressElement.attributeValue(APPLICATION_XML_ACTIVE));
                if (!active) continue;
                addresses.add(new RemoteAddress(remoteAddressElement.attributeValue(APPLICATION_XML_REMOTE_ADDRESSES_VALUE)));
            }
        }
        return addresses;
    }

    private ApplicationType getApplicationType(Map<String, Set<String>> applicationAttributeValues) {
        ApplicationType applicationType;
        Set<String> values = applicationAttributeValues.get(APPLICATION_XML_APPLICATION_TYPE_ATTRIBUTE_NAME);
        if (values != null && !values.isEmpty()) {
            try {
                applicationType = ApplicationType.valueOf((String)values.iterator().next());
            }
            catch (IllegalArgumentException e) {
                applicationType = ApplicationType.GENERIC_APPLICATION;
            }
        } else {
            applicationType = ApplicationType.GENERIC_APPLICATION;
        }
        return applicationType;
    }
}

