/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.XmlMapper;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class ApplicationMapper
extends XmlMapper
implements Mapper {
    public static final String APPLICATION_XML_ROOT = "applications";
    public static final String APPLICATION_XML_NODE = "application";
    public static final String APPLICATION_XML_TYPE = "type";
    public static final String APPLICATION_XML_DESCRIPTION = "description";
    public static final String APPLICATION_XML_CREDENTIAL = "credential";
    public static final String APPLICATION_XML_REMOTE_ADDRESSES = "remoteAddresses";
    public static final String APPLICATION_XML_REMOTE_ADDRESS = "remoteAddress";
    public static final String APPLICATION_XML_DIRECTORY_MAPPINGS = "directoryMappings";
    public static final String APPLICATION_XML_DIRECTORY_MAPPING = "directoryMapping";
    public static final String APPLICATION_XML_DIRECTORY_ID = "directoryId";
    public static final String APPLICATION_XML_DIRECTORY_ALLOW_ALL = "allowAll";
    public static final String APPLICATION_XML_PERMISSIONS = "permissions";
    public static final String APPLICATION_XML_PERMISSION = "permission";
    public static final String APPLICATION_XML_GROUP_MAPPINGS = "groupMappings";
    public static final String APPLICATION_XML_GROUP_MAPPING = "groupMapping";
    public static final String APPLICATION_XML_GROUP_NAME = "groupName";
    public static final String OPTION_DEFAULT_PASSWORD = "password";
    private final ApplicationManager applicationManager;
    private final DirectoryDAOHibernate directoryDAO;

    public ApplicationMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, ApplicationManager applicationManager, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor);
        this.applicationManager = applicationManager;
        this.directoryDAO = directoryDAO;
    }

    @Override
    public Element exportXml(Map options) throws ExportException {
        Element applicationRoot = DocumentHelper.createElement((String)APPLICATION_XML_ROOT);
        List applications = this.applicationManager.findAll();
        for (Application application : applications) {
            this.addApplicationToXml((ApplicationImpl)application, applicationRoot);
        }
        return applicationRoot;
    }

    @Override
    public void importXml(Element root) throws ImportException {
        Element applicationRoot = (Element)root.selectSingleNode("/crowd/ applications");
        if (applicationRoot == null) {
            this.logger.error((Object)"No applications were found for importing!");
            return;
        }
        Iterator applications = applicationRoot.elementIterator();
        while (applications.hasNext()) {
            Element applicationElement = (Element)applications.next();
            ApplicationImpl application = this.getApplicationFromXml(applicationElement);
            this.addEntity(application);
        }
    }

    protected void addApplicationToXml(ApplicationImpl application, Element directoryRoot) {
        Element applicationElement = directoryRoot.addElement(APPLICATION_XML_NODE);
        this.exportInternalEntity((InternalEntity)application, applicationElement);
        applicationElement.addElement(APPLICATION_XML_TYPE).addText(application.getType().name());
        applicationElement.addElement(APPLICATION_XML_DESCRIPTION).addText(StringUtils.defaultString((String)application.getDescription()));
        applicationElement.addElement(APPLICATION_XML_CREDENTIAL).addText(application.getCredential().getCredential());
        this.addRemoteAddressesToXml(new TreeSet<RemoteAddress>(application.getRemoteAddresses()), applicationElement);
        this.exportSingleValuedAttributes((Attributes)application, applicationElement);
        this.addDirectoryMappingsToXml(application.getDirectoryMappings(), applicationElement);
    }

    private void addRemoteAddressesToXml(SortedSet<RemoteAddress> remoteAddresses, Element applicationElement) {
        Element remoteAddressesElement = applicationElement.addElement(APPLICATION_XML_REMOTE_ADDRESSES);
        for (RemoteAddress remoteAddress : remoteAddresses) {
            remoteAddressesElement.addElement(APPLICATION_XML_REMOTE_ADDRESS).addText(remoteAddress.getAddress());
        }
    }

    private void addDirectoryMappingsToXml(List<DirectoryMapping> directoryMappings, Element applicationElement) {
        Element directoryMappingsElement = applicationElement.addElement(APPLICATION_XML_DIRECTORY_MAPPINGS);
        for (DirectoryMapping directoryMapping : directoryMappings) {
            Element directoryMappingElement = directoryMappingsElement.addElement(APPLICATION_XML_DIRECTORY_MAPPING);
            directoryMappingElement.addElement("id").addText(directoryMapping.getId().toString());
            directoryMappingElement.addElement(APPLICATION_XML_DIRECTORY_ID).addText(directoryMapping.getDirectory().getId().toString());
            directoryMappingElement.addElement(APPLICATION_XML_DIRECTORY_ALLOW_ALL).addText(Boolean.toString(directoryMapping.isAllowAllToAuthenticate()));
            TreeSet<GroupMapping> groupMappings = new TreeSet<GroupMapping>((Comparator<GroupMapping>)new GroupMapping.COMPARATOR());
            groupMappings.addAll(directoryMapping.getAuthorisedGroups());
            this.addGroupMappingsToXml(groupMappings, directoryMappingElement);
            this.addDirectoryPermissionsToXml(new TreeSet<OperationType>(directoryMapping.getAllowedOperations()), directoryMappingElement);
        }
    }

    private void addDirectoryPermissionsToXml(SortedSet<OperationType> operations, Element directoryMappingElement) {
        Element permissionsElement = directoryMappingElement.addElement(APPLICATION_XML_PERMISSIONS);
        for (OperationType operation : operations) {
            permissionsElement.addElement(APPLICATION_XML_PERMISSION).addText(operation.name());
        }
    }

    private void addGroupMappingsToXml(SortedSet<GroupMapping> groupMappings, Element directoryMappingElement) {
        Element groupMappingsElement = directoryMappingElement.addElement(APPLICATION_XML_GROUP_MAPPINGS);
        for (GroupMapping groupMapping : groupMappings) {
            Element groupMappingElement = groupMappingsElement.addElement(APPLICATION_XML_GROUP_MAPPING);
            groupMappingElement.addElement("id").addText(groupMapping.getId().toString());
            groupMappingElement.addElement(APPLICATION_XML_GROUP_NAME).addText(groupMapping.getGroupName());
        }
    }

    protected ApplicationImpl getApplicationFromXml(Element applicationElement) {
        InternalEntityTemplate template = this.getInternalEntityTemplateFromXml(applicationElement);
        ApplicationImpl application = new ApplicationImpl(template);
        application.setType(ApplicationType.valueOf((String)applicationElement.element(APPLICATION_XML_TYPE).getText()));
        application.setDescription(applicationElement.element(APPLICATION_XML_DESCRIPTION).getText());
        application.setCredential(new PasswordCredential(applicationElement.element(APPLICATION_XML_CREDENTIAL).getText(), true));
        Element remoteAddressesElement = applicationElement.element(APPLICATION_XML_REMOTE_ADDRESSES);
        Iterator addresses = remoteAddressesElement.elementIterator();
        while (addresses.hasNext()) {
            Element remoteAddressElement = (Element)addresses.next();
            application.addRemoteAddress(remoteAddressElement.getText());
        }
        Map<String, String> attributes = this.getSingleValuedAttributesMapFromXml(applicationElement);
        application.setAttributes(attributes);
        Element directoryMappingsElement = applicationElement.element(APPLICATION_XML_DIRECTORY_MAPPINGS);
        Iterator directoryMappingsIter = directoryMappingsElement.elementIterator();
        while (directoryMappingsIter.hasNext()) {
            Element directoryMappingElement = (Element)directoryMappingsIter.next();
            Long directoryMappingId = Long.parseLong(directoryMappingElement.element("id").getText());
            Long directoryId = Long.parseLong(directoryMappingElement.element(APPLICATION_XML_DIRECTORY_ID).getText());
            Directory directoryReference = (Directory)this.directoryDAO.loadReference(directoryId.longValue());
            boolean allowAll = Boolean.parseBoolean(directoryMappingElement.element(APPLICATION_XML_DIRECTORY_ALLOW_ALL).getText());
            DirectoryMapping directoryMapping = new DirectoryMapping(directoryMappingId, (Application)application, directoryReference, allowAll);
            Element groupMappingsElement = directoryMappingElement.element(APPLICATION_XML_GROUP_MAPPINGS);
            Iterator groupMappingsIter = groupMappingsElement.elementIterator();
            while (groupMappingsIter.hasNext()) {
                Element groupMappingElement = (Element)groupMappingsIter.next();
                Long groupMappingId = Long.parseLong(groupMappingElement.element("id").getText());
                String groupName = groupMappingElement.element(APPLICATION_XML_GROUP_NAME).getText();
                GroupMapping groupMapping = new GroupMapping(groupMappingId, directoryMapping, groupName);
                directoryMapping.getAuthorisedGroups().add(groupMapping);
            }
            Element permissionsElement = directoryMappingElement.element(APPLICATION_XML_PERMISSIONS);
            Iterator permissionsIter = permissionsElement.elementIterator();
            while (permissionsIter.hasNext()) {
                Element permissionElement = (Element)permissionsIter.next();
                OperationType operation = OperationType.valueOf((String)permissionElement.getText());
                directoryMapping.addAllowedOperations(new OperationType[]{operation});
            }
            application.getDirectoryMappings().add(directoryMapping);
        }
        return application;
    }
}

