/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.login;

import com.atlassian.crowd.dao.token.ResetPasswordTokenDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.event.login.RequestResetPasswordEvent;
import com.atlassian.crowd.event.login.RequestUsernamesEvent;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.token.ResetPasswordToken;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.security.random.SecureTokenGenerator;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class ForgottenLoginManagerImpl
implements ForgottenLoginManager {
    private static final int TOKEN_EXPIRY_HOURS = 24;
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String RESET_PASSWORD_ACTION = "/console/resetpassword.action";
    private final Logger logger = Logger.getLogger(this.getClass());
    private final ApplicationService applicationService;
    private final DirectoryManager directoryManager;
    private final PermissionManager permissionManager;
    private final ResetPasswordTokenDao resetPasswordTokenDao;
    private final SecureTokenGenerator tokenGenerator;
    private final ClientProperties clientProperties;
    private final EventPublisher eventPublisher;

    public ForgottenLoginManagerImpl(ApplicationService applicationService, DirectoryManager directoryManager, PermissionManager permissionManager, ResetPasswordTokenDao resetPasswordTokenDao, SecureTokenGenerator tokenGenerator, ClientProperties clientProperties, EventPublisher eventPublisher) {
        this.applicationService = (ApplicationService)Preconditions.checkNotNull((Object)applicationService);
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.resetPasswordTokenDao = (ResetPasswordTokenDao)Preconditions.checkNotNull((Object)resetPasswordTokenDao);
        this.tokenGenerator = (SecureTokenGenerator)Preconditions.checkNotNull((Object)tokenGenerator);
        this.clientProperties = (ClientProperties)Preconditions.checkNotNull((Object)clientProperties);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
    }

    public void sendResetLink(Application application, String username) throws UserNotFoundException, InvalidEmailAddressException, ApplicationPermissionException {
        Directory directory;
        User user = this.applicationService.findUserByName(application, username);
        try {
            directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        }
        catch (DirectoryNotFoundException e) {
            throw new ConcurrentModificationException("Directory " + user.getDirectoryId() + " no longer exists.");
        }
        if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) {
            throw new ApplicationPermissionException("Not allowed to update user '" + user.getName() + "' in directory '" + directory.getName() + "'.");
        }
        this.sendResetLink(user, directory);
    }

    public void sendUsernames(Application application, String email) throws InvalidEmailAddressException {
        List users = this.applicationService.searchUsers(application, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)email)).returningAtMost(-1));
        if (!users.isEmpty()) {
            User user = (User)users.get(0);
            List usernames = Lists.transform((List)users, (Function)new Function<User, String>(){

                public String apply(User user) {
                    return user.getName();
                }
            });
            this.eventPublisher.publish((Object)new RequestUsernamesEvent(user, usernames));
        } else {
            this.logger.info((Object)("No usernames found for email address: " + email));
        }
    }

    public void sendResetLink(long directoryId, String username) throws DirectoryNotFoundException, InvalidEmailAddressException, UserNotFoundException, OperationFailedException {
        User user = this.directoryManager.findUserByName(directoryId, username);
        this.sendResetLink(user, this.directoryManager.findDirectoryById(directoryId));
    }

    public boolean isValidResetToken(long directoryId, String username, String token) {
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)token)) {
            return false;
        }
        try {
            ResetPasswordToken resetPasswordToken = this.resetPasswordTokenDao.findTokenByUsername(username);
            LocalDateTime now = new LocalDateTime();
            if (!resetPasswordToken.getToken().equals(token) || now.isAfter((ReadablePartial)new LocalDateTime(resetPasswordToken.getExpiryDate())) || resetPasswordToken.getDirectoryId() != directoryId) {
                return false;
            }
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        return true;
    }

    public void resetUserCredential(long directoryId, String username, PasswordCredential credential, String token) throws DirectoryNotFoundException, UserNotFoundException, InvalidResetPasswordTokenException, OperationFailedException, InvalidCredentialException, DirectoryPermissionException {
        if (!this.isValidResetToken(directoryId, username, token)) {
            throw new InvalidResetPasswordTokenException("No valid reset token found for user");
        }
        this.directoryManager.updateUserCredential(directoryId, username, credential);
        this.resetPasswordTokenDao.removeTokenByUsername(username);
    }

    private void validateUser(User user) throws InvalidEmailAddressException {
        if (StringUtils.isBlank((String)user.getEmailAddress())) {
            throw new InvalidEmailAddressException("Cannot email a reset password link; user's email address is blank.");
        }
        try {
            new InternetAddress(user.getEmailAddress()).validate();
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException((Throwable)e);
        }
    }

    private ResetPasswordToken createAndStoreResetToken(String username, long directoryId) {
        String token = this.tokenGenerator.generateToken();
        LocalDateTime expiryDate = new LocalDateTime().plusHours(24);
        ResetPasswordToken resetPasswordToken = new ResetPasswordToken(expiryDate.toDateTime().getMillis(), token, username, directoryId);
        this.resetPasswordTokenDao.addToken(resetPasswordToken);
        return resetPasswordToken;
    }

    private void sendResetLink(User user, Directory directory) throws InvalidEmailAddressException {
        this.validateUser(user);
        this.logger.info((Object)("\"" + user.getName() + "\" in \"" + directory.getName() + "\" is being e-mailed a password reset link."));
        ResetPasswordToken resetToken = this.createAndStoreResetToken(user.getName(), directory.getId());
        this.emailResetToken(resetToken, user);
    }

    private void emailResetToken(ResetPasswordToken resetToken, User user) throws InvalidEmailAddressException {
        String baseURL = this.clientProperties.getBaseURL();
        String encUsername = "";
        String encToken = "";
        String encDirectoryId = "";
        try {
            encUsername = URLEncoder.encode(resetToken.getUsername(), UTF8_ENCODING);
            encToken = URLEncoder.encode(resetToken.getToken(), UTF8_ENCODING);
            encDirectoryId = URLEncoder.encode(Long.toString(resetToken.getDirectoryId()), UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode username and token: this Java VM does not support UTF-8", e);
        }
        String resetLink = baseURL + RESET_PASSWORD_ACTION + "?username=" + encUsername + "&directoryId=" + encDirectoryId + "&token=" + encToken;
        this.eventPublisher.publish((Object)new RequestResetPasswordEvent(user, resetLink));
    }
}

