/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.config;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.log4j.Logger;

public class CsvConfiguration
extends Configuration
implements Serializable {
    public static final String USER_PREFIX = "user.";
    public static final String USER_FIRSTNAME = "user.firstname";
    public static final String USER_LASTNAME = "user.lastname";
    public static final String USER_EMAILADDRESS = "user.emailaddress";
    public static final String USER_USERNAME = "user.username";
    public static final String USER_PASSWORD = "user.password";
    public static final String USER_NONE = "user.none";
    public static final String GROUP_PREFIX = "group.";
    public static final String GROUP_NAME = "group.name";
    public static final String GROUP_USERNAME = "group.username";
    public static final String GROUP_NONE = "group.none";
    private File users;
    private File groupMemberships;
    private Character delimiter;
    private Boolean encryptPasswords = Boolean.TRUE;
    private OrderedBidiMap userMappingConfiguration;
    private OrderedBidiMap groupMappingConfiguration;
    private List userHeaderRow;
    private List userSampleRow;
    private List groupHeaderRow;
    private List groupSampleRow;
    private static final Logger logger = Logger.getLogger(CsvConfiguration.class);

    public CsvConfiguration() {
    }

    public CsvConfiguration(Long directoryID, String application, Boolean importPasswords, File users, File groupMemberships, Character delimiter, Boolean encryptPasswords) {
        super(directoryID, application, importPasswords, Boolean.FALSE);
        this.users = users;
        this.groupMemberships = groupMemberships;
        this.delimiter = delimiter;
        this.encryptPasswords = encryptPasswords;
        this.buildSampleUserMapping(users);
        this.buildSampleGroupMapping(groupMemberships);
    }

    protected void buildSampleUserMapping(File csvDataFile) {
        if (csvDataFile != null && this.getDelimiter() != null) {
            try {
                CSVStrategy strategy = CSVStrategy.EXCEL_STRATEGY;
                strategy.setDelimiter(this.getDelimiter().charValue());
                CSVParser csvParser = new CSVParser((Reader)new FileReader(csvDataFile), strategy);
                String[] dataRow = csvParser.getLine();
                if (dataRow != null && dataRow.length > 0) {
                    this.userHeaderRow = Arrays.asList(dataRow);
                }
                if ((dataRow = csvParser.getLine()) != null && dataRow.length > 0) {
                    this.userSampleRow = Arrays.asList(dataRow);
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void buildSampleGroupMapping(File csvDataFile) {
        if (csvDataFile != null && this.getDelimiter() != null) {
            try {
                CSVStrategy strategy = CSVStrategy.EXCEL_STRATEGY;
                strategy.setDelimiter(this.getDelimiter().charValue());
                CSVParser csvParser = new CSVParser((Reader)new FileReader(csvDataFile), strategy);
                String[] dataRow = csvParser.getLine();
                if (dataRow != null && dataRow.length > 0) {
                    this.groupHeaderRow = Arrays.asList(dataRow);
                }
                if ((dataRow = csvParser.getLine()) != null && dataRow.length > 0) {
                    this.groupSampleRow = Arrays.asList(dataRow);
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void isValid() throws ImporterConfigurationException {
        super.isValid();
        if (this.users == null || this.delimiter == null || this.encryptPasswords == null) {
            throw new ImporterConfigurationException("A required Configuration value was null: " + this);
        }
    }

    public File getUsers() {
        return this.users;
    }

    public void setUsers(File users) {
        this.users = users;
        this.buildSampleUserMapping(users);
    }

    public File getGroupMemberships() {
        return this.groupMemberships;
    }

    public void setGroupMemberships(File groupMemberships) {
        this.groupMemberships = groupMemberships;
        this.buildSampleGroupMapping(groupMemberships);
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean isEncryptPasswords() {
        return this.encryptPasswords;
    }

    public void setEncryptPasswords(Boolean encryptPasswords) {
        this.encryptPasswords = encryptPasswords;
    }

    public List getUserHeaderRow() {
        if (this.userHeaderRow == null) {
            this.buildSampleUserMapping(this.users);
        }
        return this.userHeaderRow;
    }

    public List getUserSampleRow() {
        if (this.userSampleRow == null) {
            this.buildSampleUserMapping(this.users);
        }
        return this.userSampleRow;
    }

    public List getGroupHeaderRow() {
        if (this.groupHeaderRow == null) {
            this.buildSampleGroupMapping(this.groupMemberships);
        }
        return this.groupHeaderRow;
    }

    public List getGroupSampleRow() {
        if (this.groupSampleRow == null) {
            this.buildSampleGroupMapping(this.groupMemberships);
        }
        return this.groupSampleRow;
    }

    public OrderedBidiMap getUserMappingConfiguration() {
        return this.userMappingConfiguration;
    }

    public void setUserMappingConfiguration(OrderedBidiMap userMappingConfiguration) {
        this.userMappingConfiguration = userMappingConfiguration;
    }

    public OrderedBidiMap getGroupMappingConfiguration() {
        return this.groupMappingConfiguration;
    }

    public void setGroupMappingConfiguration(OrderedBidiMap groupMappingConfiguration) {
        this.groupMappingConfiguration = groupMappingConfiguration;
    }
}

