/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask502
implements UpgradeTask {
    private static final char DELIMITER = ',';
    private PropertyManager propertyManager;

    @Override
    public String getBuildNumber() {
        return "502";
    }

    @Override
    public String getShortDescription() {
        return "Clean up null trusted proxy entries if they exist";
    }

    @Override
    public void doUpgrade() throws Exception {
        String proxiesString;
        try {
            proxiesString = this.propertyManager.getTrustedProxyServers();
        }
        catch (PropertyManagerException e) {
            return;
        }
        if (!StringUtils.isBlank((String)proxiesString)) {
            String[] proxies = StringUtils.split((String)proxiesString, (char)',');
            HashSet<String> resultSet = new HashSet<String>();
            for (String proxy : proxies) {
                if (StringUtils.isBlank((String)proxy)) continue;
                resultSet.add(proxy);
            }
            this.propertyManager.setTrustedProxyServers(StringUtils.join(resultSet, (char)','));
        }
    }

    @Override
    public Collection<String> getErrors() {
        return Collections.emptySet();
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }
}

