/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.JdbcConfiguration;
import com.atlassian.crowd.importer.importers.JdbcImporter;
import com.atlassian.crowd.importer.mappers.jdbc.UserMembershipMapper;
import com.atlassian.crowd.importer.model.MembershipDTO;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.PasswordHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CrowdifiedConfluenceImporter
extends JdbcImporter {
    private static final String CROWD_SOURCE_DIRECTORY_COUNT = "SELECT COUNT(id) FROM cwd_directory WHERE directory_type = 'INTERNAL'";
    private static final String CROWD_INTERNAL_DIRECTORIES_SQL = "SELECT id, directory_name FROM cwd_directory WHERE directory_type = 'INTERNAL'";
    private static final String FIND_GROUPS_SQL = "SELECT group_name, description, active FROM cwd_group WHERE directory_id = ?";
    private static final String FIND_USERS_SQL = "SELECT user_name, email_address, credential, first_name, last_name, display_name, active FROM cwd_user WHERE directory_id = ?";
    private static final String FIND_USER_GROUP_MEMBERSHIPS = "SELECT usr.user_name AS user_name, grp.group_name AS group_name FROM cwd_membership mem INNER JOIN cwd_group grp ON mem.parent_id = grp.id INNER JOIN cwd_user usr ON mem.child_user_id = usr.id WHERE usr.directory_id = ?";

    public CrowdifiedConfluenceImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager, passwordHelper);
    }

    @Override
    public Collection<GroupTemplate> findGroups(Configuration configuration) {
        return this.jdbcTemplate.query(FIND_GROUPS_SQL, new Object[]{((JdbcConfiguration)configuration).getSourceDirectoryID()}, this.getGroupMapper(configuration));
    }

    @Override
    public List<MembershipDTO> findUserToGroupMemberships(Configuration configuration) {
        return this.jdbcTemplate.query(FIND_USER_GROUP_MEMBERSHIPS, new Object[]{((JdbcConfiguration)configuration).getSourceDirectoryID()}, this.getMembershipMapper());
    }

    @Override
    public List<UserTemplateWithCredentialAndAttributes> findUsers(Configuration configuration) {
        return this.jdbcTemplate.query(FIND_USERS_SQL, new Object[]{((JdbcConfiguration)configuration).getSourceDirectoryID()}, this.getUserMapper(configuration, this.passwordHelper));
    }

    @Override
    public String getSelectAllUserGroupMembershipsSQL() {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public String getSelectAllGroupsSQL() {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public String getSelectAllUsersSQL() {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public RowMapper getGroupMapper(Configuration configuration) {
        return new CrowdifiedConfluenceGroupMapper(configuration.getDirectoryID());
    }

    @Override
    public RowMapper getUserMapper(Configuration configuration, PasswordHelper passwordHelper) {
        return new CrowdifiedConfluenceUserMapper(configuration, passwordHelper);
    }

    @Override
    public RowMapper getMembershipMapper() {
        return new UserMembershipMapper("user_name", "group_name");
    }

    @Override
    public boolean supportsMultipleDirectories(Configuration configuration) {
        this.init(configuration);
        try {
            return this.jdbcTemplate.queryForInt(CROWD_SOURCE_DIRECTORY_COUNT) > 0;
        }
        catch (BadSqlGrammarException bsge) {
            return false;
        }
    }

    @Override
    public Set<Directory> retrieveRemoteSourceDirectory(Configuration configuration) {
        this.init(configuration);
        return new HashSet<Directory>(this.jdbcTemplate.query(CROWD_INTERNAL_DIRECTORIES_SQL, (RowMapper)new MinimalistConfluenceDirectoryMapper()));
    }

    protected static class CrowdifiedConfluenceUserMapper
    implements RowMapper {
        private final Configuration configuration;
        private final PasswordHelper passwordHelper;

        public CrowdifiedConfluenceUserMapper(Configuration configuration, PasswordHelper passwordHelper) {
            this.configuration = configuration;
            this.passwordHelper = passwordHelper;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            String usernameStr = rs.getString("user_name");
            PasswordCredential credential = null;
            credential = this.configuration.isImportPasswords() != false ? new PasswordCredential(rs.getString("credential"), true) : new PasswordCredential(this.passwordHelper.generateRandomPassword(), false);
            UserTemplate user = new UserTemplate(usernameStr, this.configuration.getDirectoryID().longValue());
            String activeStr = rs.getString("active").trim();
            user.setActive(activeStr != null && activeStr.equals("T"));
            user.setEmailAddress(rs.getString("email_address"));
            user.setFirstName(rs.getString("first_name"));
            user.setLastName(rs.getString("last_name"));
            user.setDisplayName(rs.getString("display_name"));
            return new UserTemplateWithCredentialAndAttributes((User)user, credential);
        }
    }

    protected static class CrowdifiedConfluenceGroupMapper
    implements RowMapper {
        private final Long directoryId;

        public CrowdifiedConfluenceGroupMapper(Long directoryId) {
            this.directoryId = directoryId;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            String groupName = rs.getString("group_name");
            GroupTemplate group = new GroupTemplate(groupName, this.directoryId.longValue(), GroupType.GROUP);
            String activeStr = rs.getString("active").trim();
            group.setActive(activeStr != null && activeStr.equals("T"));
            group.setDescription(rs.getString("description"));
            return group;
        }
    }

    private static class MinimalistConfluenceDirectoryMapper
    implements RowMapper {
        private MinimalistConfluenceDirectoryMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new DirectoryImpl(new InternalEntityTemplate(Long.valueOf(rs.getLong("id")), rs.getString("directory_name"), true, null, null));
        }
    }
}

