/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.JdbcConfiguration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.model.Result;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.util.PasswordHelper;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseDelegatingJdbcImporter
implements Importer {
    protected JdbcOperations jdbcTemplate;
    protected DirectoryManager directoryManager;
    protected PasswordHelper passwordHelper;

    public BaseDelegatingJdbcImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        this.directoryManager = directoryManager;
        this.passwordHelper = passwordHelper;
    }

    @Override
    public void init(Configuration configuration) {
        this.setJdbcTemplate((JdbcConfiguration)configuration);
    }

    @Override
    public Class getConfigurationType() {
        return JdbcConfiguration.class;
    }

    public void setJdbcTemplate(JdbcConfiguration configuration) {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(configuration.getDatabaseDriver(), configuration.getDatabaseURL(), configuration.getUsername(), configuration.getPassword());
        this.jdbcTemplate = new JdbcTemplate((DataSource)driverManagerDataSource);
    }

    abstract Importer determineImporter(Configuration var1) throws ImporterException;

    @Override
    public Result importUsersGroupsAndMemberships(Configuration configuration) throws ImporterException {
        Importer importer = this.determineImporter(configuration);
        return importer.importUsersGroupsAndMemberships(configuration);
    }

    @Override
    public boolean supportsMultipleDirectories(Configuration configuration) throws ImporterException {
        Importer importer = this.determineImporter(configuration);
        return importer.supportsMultipleDirectories(configuration);
    }

    @Override
    public Set<Directory> retrieveRemoteSourceDirectory(Configuration configuration) throws ImporterException {
        Importer importer = this.determineImporter(configuration);
        return importer.retrieveRemoteSourceDirectory(configuration);
    }
}

