/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.token.factory;

import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.manager.token.factory.TokenKeyGenerator;
import com.atlassian.crowd.manager.validation.XForwardedForUtil;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenKeyGeneratorImpl
implements TokenKeyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenKeyGeneratorImpl.class);
    private final String algorithm;
    private final TrustedProxyManager trustedProxyManager;

    public TokenKeyGeneratorImpl(TrustedProxyManager trustedProxyManager, String algorithm) {
        this.trustedProxyManager = trustedProxyManager;
        this.algorithm = algorithm;
    }

    @Override
    public String generateKey(long directoryID, String name, List<ValidationFactor> validationFactors) throws InvalidTokenException {
        MessageDigest messageDigest;
        LOGGER.debug("Generating Token for principal: {}", (Object)name);
        try {
            messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidTokenException((Throwable)e);
        }
        String message = this.constructMessage(directoryID, name, validationFactors);
        byte[] digest = messageDigest.digest(message.getBytes());
        return this.makeUrlSafe(this.base64Encode(digest)).trim();
    }

    private String constructMessage(long directoryID, String name, List<ValidationFactor> validationFactors) {
        StringBuilder message = new StringBuilder();
        this.addValidationFactors(message, validationFactors);
        message.append(Long.toString(directoryID));
        message.append(StringUtils.lowerCase((String)name));
        return message.toString();
    }

    private String base64Encode(byte[] digest) {
        try {
            return new String(Base64.encodeBase64((byte[])digest), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode token: this Java VM does not support UTF-8", e);
        }
    }

    private String makeUrlSafe(String encodedToken) {
        return encodedToken.replaceAll("\\+|/|=|\\*", "0");
    }

    private void addValidationFactors(StringBuilder message, List<ValidationFactor> validationFactors) {
        if (validationFactors != null) {
            ValidationFactor remoteIP = this.getFactor(validationFactors, "remote_address");
            if (remoteIP != null) {
                ValidationFactor xForwardedFor = this.getFactor(validationFactors, "X-Forwarded-For");
                String xff = xForwardedFor == null ? null : xForwardedFor.getValue();
                String remoteAddress = XForwardedForUtil.getTrustedAddress((TrustedProxyManager)this.trustedProxyManager, (String)remoteIP.getValue(), (String)xff);
                LOGGER.debug("Adding remote address of {}", (Object)remoteAddress);
                message.append(remoteAddress);
            }
            this.addValidationFactor(message, validationFactors, "remote_host");
            this.addValidationFactor(message, validationFactors, "NAME");
            this.addValidationFactor(message, validationFactors, "Random-Number");
        }
    }

    private ValidationFactor getFactor(List<ValidationFactor> validationFactors, String factorName) {
        for (ValidationFactor validationFactor : validationFactors) {
            if (!factorName.equals(validationFactor.getName())) continue;
            return validationFactor;
        }
        return null;
    }

    protected void addValidationFactor(StringBuilder message, List<ValidationFactor> validationFactors, String factorName) {
        ValidationFactor factor = this.getFactor(validationFactors, factorName);
        if (factor != null) {
            LOGGER.debug("Adding {} of {}", (Object)factorName, (Object)factor);
            message.append(factor.getValue());
        }
    }
}

