/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.listener;

import com.atlassian.crowd.event.EventJobExecutionException;
import com.atlassian.crowd.event.login.RequestResetPasswordEvent;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.manager.login.util.ForgottenLoginMailer;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.event.api.EventListener;
import com.google.common.base.Preconditions;

public class RequestResetPasswordListener {
    private ForgottenLoginMailer forgottenLoginMailer;

    @EventListener
    public void handleEvent(RequestResetPasswordEvent requestResetPasswordEvent) {
        try {
            this.forgottenLoginMailer.mailResetPasswordLink(requestResetPasswordEvent.getUser(), requestResetPasswordEvent.getResetLink());
        }
        catch (InvalidEmailAddressException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
        catch (MailSendException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
    }

    public void setForgottenLoginMailer(ForgottenLoginMailer forgottenLoginMailer) {
        this.forgottenLoginMailer = (ForgottenLoginMailer)Preconditions.checkNotNull((Object)forgottenLoginMailer);
    }
}

