/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask396
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private final Collection<String> errors = new ArrayList<String>();
    public static final String ATTRIBUTE_KEY_USE_CACHING = "useCaching";
    public static final String ATTRIBUTE_KEY_USE_MONITORING = "useMonitoring";

    @Override
    public String getBuildNumber() {
        return "396";
    }

    @Override
    public String getShortDescription() {
        return "Disabling caching for LDAP directories with roles enabled";
    }

    @Override
    public void doUpgrade() throws Exception {
        List ldapDirectories = this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CONNECTOR)).returningAtMost(-1));
        for (Directory directory : ldapDirectories) {
            if (Boolean.parseBoolean(directory.getValue("ldap.roles.disabled"))) continue;
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            directoryToUpdate.setAttribute(ATTRIBUTE_KEY_USE_CACHING, Boolean.FALSE.toString());
            directoryToUpdate.setAttribute(ATTRIBUTE_KEY_USE_MONITORING, Boolean.FALSE.toString());
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

