/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMigrator {
    private final Logger logger = Logger.getLogger(XmlMigrator.class);
    private final List<Mapper> mappers;

    public XmlMigrator(List<Mapper> mappers) {
        this.mappers = mappers;
    }

    public void exportXml(Element root, Map options) throws ExportException {
        for (Mapper mapper : this.mappers) {
            Element mapping = mapper.exportXml(options);
            if (mapping == null) continue;
            root.add(mapping);
        }
    }

    public void importXml(Element root) throws ImportException {
        for (Mapper mapper : this.mappers) {
            this.logger.info((Object)("Using " + mapper.getClass().getName() + " to import."));
            mapper.importXml(root);
        }
    }
}

