/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.token.factory;

import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.manager.token.factory.TokenKeyGenerator;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenKeyGeneratorImpl
implements TokenKeyGenerator {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final String algorithm;
    private final TrustedProxyManager trustedProxyManager;

    public TokenKeyGeneratorImpl(TrustedProxyManager trustedProxyManager, String algorithm) {
        this.trustedProxyManager = trustedProxyManager;
        this.algorithm = algorithm;
    }

    @Override
    public String generateKey(long directoryID, String name, List<ValidationFactor> validationFactors) throws InvalidTokenException {
        MessageDigest messageDigest;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generating Token for principal: " + name));
        }
        try {
            messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidTokenException((Throwable)e);
        }
        String message = this.constructMessage(directoryID, name, validationFactors);
        byte[] digest = messageDigest.digest(message.getBytes());
        return this.makeUrlSafe(this.base64Encode(digest)).trim();
    }

    private String constructMessage(long directoryID, String name, List<ValidationFactor> validationFactors) {
        StringBuffer message = new StringBuffer();
        this.addValidationFactors(message, validationFactors);
        message.append(Long.toString(directoryID));
        message.append(StringUtils.lowerCase((String)name));
        return message.toString();
    }

    private String base64Encode(byte[] digest) {
        try {
            return new String(Base64.encodeBase64((byte[])digest), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode token: this Java VM does not support UTF-8", e);
        }
    }

    private String makeUrlSafe(String encodedToken) {
        return encodedToken.replaceAll("\\+|/|=|\\*", "0");
    }

    private void addValidationFactors(StringBuffer message, List<ValidationFactor> validationFactors) {
        if (validationFactors != null) {
            ValidationFactor remoteIP = this.getFactor(validationFactors, "remote_address");
            if (remoteIP != null) {
                String remoteAddress = null;
                ValidationFactor xForwardedFor = this.getFactor(validationFactors, "X-Forwarded-For");
                if (xForwardedFor != null && this.isTrustedProxy(remoteIP.getValue())) {
                    remoteAddress = this.getLastXFF(xForwardedFor.getValue());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding X-Forwarded-For remote address of " + remoteAddress));
                    }
                } else {
                    if (this.logger.isDebugEnabled() && xForwardedFor != null && !this.isTrustedProxy(remoteIP.getValue())) {
                        this.logger.debug((Object)("The Proxy forwarding the Client remote address is not trusted. Please, check if requests coming from" + remoteIP.getValue() + "are safe and if this address " + "should be added to Crowd Trusted Proxy Servers list. See http://confluence.atlassian.com/x/U4ZsCQ"));
                    }
                    remoteAddress = remoteIP.getValue();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Adding remote address of " + remoteAddress));
                    }
                }
                message.append(remoteAddress);
            }
            this.addValidationFactor(message, validationFactors, "remote_host");
            this.addValidationFactor(message, validationFactors, "NAME");
            this.addValidationFactor(message, validationFactors, "Random-Number");
        }
    }

    private ValidationFactor getFactor(List<ValidationFactor> validationFactors, String factorName) {
        for (ValidationFactor validationFactor : validationFactors) {
            if (!factorName.equals(validationFactor.getName())) continue;
            return validationFactor;
        }
        return null;
    }

    private boolean isTrustedProxy(String remoteAddress) {
        return this.trustedProxyManager.isTrusted(remoteAddress);
    }

    private String getLastXFF(String xForwardedFor) {
        int split = xForwardedFor.lastIndexOf(44);
        if (split != -1 && split < xForwardedFor.length() - 2) {
            return xForwardedFor.substring(split + 1);
        }
        return xForwardedFor;
    }

    protected void addValidationFactor(StringBuffer message, List<ValidationFactor> validationFactors, String factorName) {
        ValidationFactor factor = this.getFactor(validationFactors, factorName);
        if (factor != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding " + factorName + " of " + factor));
            }
            message.append(factor.getValue());
        }
    }
}

