/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.validation;

import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.manager.validation.XForwardedForUtil;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.InetAddressCacheUtil;
import com.atlassian.ip.IPMatcher;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientValidationManagerImpl
implements ClientValidationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientValidationManagerImpl.class);
    private final InetAddressCacheUtil cacheUtil;
    private final PropertyManager propertyManager;
    private final TrustedProxyManager trustedProxyManager;
    private final I18nHelper i18nHelper;

    public ClientValidationManagerImpl(InetAddressCacheUtil cacheUtil, PropertyManager propertyManager, TrustedProxyManager trustedProxyManager, I18nHelper i18nHelper) {
        this.cacheUtil = cacheUtil;
        this.propertyManager = propertyManager;
        this.trustedProxyManager = trustedProxyManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public void validate(Application application, HttpServletRequest request) throws ClientValidationException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)request);
        this.validateApplicationActive(application);
        this.validateRemoteAddress(application, request);
    }

    private void validateApplicationActive(Application application) throws ClientValidationException {
        if (!application.isActive()) {
            throw new ClientValidationException(this.i18nHelper.getText("application.inactive.error", application.getName()));
        }
    }

    private void validateRemoteAddress(Application application, HttpServletRequest request) throws ClientValidationException {
        boolean addressValid;
        InetAddress clientAddress = XForwardedForUtil.getTrustedAddress(this.trustedProxyManager, request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Client address: " + clientAddress.getHostAddress());
        }
        if (this.propertyManager.isCacheEnabled()) {
            try {
                addressValid = this.cacheUtil.getPermitted(application, clientAddress);
            }
            catch (NotInCacheException e) {
                addressValid = this.match(application.getRemoteAddresses(), clientAddress);
                this.cacheUtil.setPermitted(application, clientAddress, addressValid);
            }
        } else {
            addressValid = this.match(application.getRemoteAddresses(), clientAddress);
        }
        if (!addressValid) {
            String errorMsg = this.i18nHelper.getText("client.forbidden.exception", clientAddress.getHostAddress(), application.getName());
            LOGGER.info(errorMsg);
            throw new ClientValidationException(errorMsg);
        }
    }

    private boolean match(Iterable<RemoteAddress> allowedAddresses, InetAddress requestAddress) {
        IPMatcher.Builder ipMatcherBuilder = IPMatcher.builder();
        for (RemoteAddress allowedAddress : allowedAddresses) {
            ipMatcherBuilder.addPatternOrHost(allowedAddress.getAddress());
        }
        return ipMatcherBuilder.build().matches(requestAddress);
    }
}

