/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.authentication;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.util.List;

public interface TokenAuthenticationManager {
    public Token authenticateApplication(ApplicationAuthenticationContext var1) throws InvalidAuthenticationException;

    public Token authenticateUser(UserAuthenticationContext var1) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException, ApplicationNotFoundException;

    public Token authenticateUserWithoutValidatingPassword(UserAuthenticationContext var1) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, ApplicationAccessDeniedException, ApplicationNotFoundException;

    public Token validateApplicationToken(String var1, ValidationFactor[] var2) throws InvalidTokenException;

    public Token validateUserToken(String var1, ValidationFactor[] var2, String var3) throws InvalidTokenException, ApplicationAccessDeniedException, OperationFailedException;

    public void invalidateToken(String var1);

    public List<Token> searchTokens(EntityQuery<Token> var1);

    public void removeExpiredTokens();

    public User findUserByToken(String var1, String var2) throws InvalidTokenException, OperationFailedException, ApplicationNotFoundException;

    public List<Application> findAuthorisedApplications(User var1, String var2) throws OperationFailedException, DirectoryNotFoundException, ApplicationNotFoundException;
}

