package com.atlassian.crowd.manager.emailscan;

import java.util.Optional;

/**
 * Service for running email issues scans for a given application. Scan counts duplicated and invalid email
 * addresses of users within a given application.
 * <p>
 * Such users are NOT authorized when Crowd acts as a SAML IdP for a SP which uses email as NameID format.
 */
public interface AppIssuesWithMailsValidationService {
    /**
     * Runs scan for a given application. Overrides previous scan result. The scan is run asynchronously and can take
     * some time to finish. Once the scan is finished, the result can be obtained by
     * {@link AppIssuesWithMailsValidationService#getLastValidationResult}.
     *
     * @param appId id of an application
     * @throws EmailsScanFailedToRunException when emails scan failed to run
     */
    void runValidation(long appId);

    /**
     * Gets result of the latest scan for a given application.
     *
     * @param appId if of an application
     * @return optional containing result of the scan, or empty optional if there is no scan result associated with
     * an app
     */
    Optional<ValidationResult> getLastValidationResult(long appId);
}
