package com.atlassian.crowd.manager.audit;

import com.atlassian.annotations.Internal;

import java.util.Set;

@Internal
public interface AuditLogProperties {
    /**
     * @return names of additional changeset properties to be sanitized
     */
    Set<String> getSanitizedProperties();

    /**
     * @return false if audit log is disabled for synchronisation or true, otherwise
     */
    boolean isAuditLogEnabledForSynchronisation();

    /**
     * @return false if audit is disabled in general or true, otherwise
     */
    boolean isAuditLogEnabled();
}