package com.atlassian.crowd.manager.audit;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.audit.AuditLogChangeset;

/**
 * Populates the audit log changeset and author
 */
@Internal
public interface AuditLogChangesetPopulator {

    /**
     * Populates the author, timestamp and IP address in the audit log changeset. The author will be populated if the author id is empty.
     * The timestamp will be adjusted if empty or if the force adjust flag is set to true.
     * @param changeset the changeset to populate
     * @param forceAdjustTimestamp if set to true, the timestamp will be adjusted even if it's currently populated
     * @return the adjusted changeset
     */
    AuditLogChangeset populateCommonChangesetProperties(AuditLogChangeset changeset, boolean forceAdjustTimestamp);
}
