package com.atlassian.crowd.feature;


import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.FeatureFlag;

/**
 * Class providing information whether given feature is enabled.
 */
@Internal
public interface FeatureEnabledChecker extends FeatureFlag {
    /**
     * Returns whether the feature is accessible under current licensing terms.
     */
    boolean isAccessible();

    /**
     * Throws {@link com.atlassian.crowd.exception.FeatureInaccessibleException} if the feature is not accessible.
     * Throws {@link com.atlassian.crowd.exception.FeatureDisabledException} if the feature is disabled.
     */
    void throwIfFeatureDisabledOrInaccessible();
}
