package com.atlassian.crowd.service.support;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.support.SupportInformationBuilder;

/**
 * Service for providing additional information to {@link com.atlassian.crowd.support.SupportInformationService}.
 */
public interface AdditionalSupportInformationService {

    /**
     * Adds additional support information to the provided builder
     * @param supportInformationBuilder the builder that will be filled with additional information
     */
    void extendSupportInformation(SupportInformationBuilder supportInformationBuilder);

    /**
     * Adds additional support information related to the specified application to the provided builder
     * @param supportInformationBuilder the builder that will be filled with additional information
     * @param application the application to which the additional information relates to
     * @param applicationIndex the index of the application, used to build prefixes for item names
     */
    default void extendSupportInformation(SupportInformationBuilder supportInformationBuilder, Application application, int applicationIndex){}
}
