package com.atlassian.crowd.manager.mail;

import com.atlassian.crowd.util.mail.SMTPServer;

import java.util.List;

/**
 * Represents a mail configuration
 *
 * @since v3.2.0
 */
public class MailConfiguration {

    private final SMTPServer smtpServer;
    private final List<String> notificationEmails;

    public MailConfiguration(Builder builder) {
        this.smtpServer = builder.smtpServer;
        this.notificationEmails = builder.notificationEmails;
    }

    public static MailConfiguration.Builder builder() {
        return new Builder();
    }

    public static MailConfiguration.Builder builder(MailConfiguration mailServerModel) {
        return new Builder(mailServerModel);
    }

    /**
     * @return configuration of mail server
     */
    public SMTPServer getSmtpServer() {
        return smtpServer;
    }

    /**
     * @return notification email addresses, which are used to retrieve notification emails (like critical server messages)
     */
    public List<String> getNotificationEmails() {
        return notificationEmails;
    }

    public static final class Builder {
        private SMTPServer smtpServer;
        private List<String> notificationEmails;

        private Builder() {
        }

        private Builder(MailConfiguration mailServerModel) {
            this.smtpServer = mailServerModel.getSmtpServer();
            this.notificationEmails = mailServerModel.getNotificationEmails();
        }

        public Builder setSmtpServer(SMTPServer smtpServer) {
            this.smtpServer = smtpServer;
            return this;
        }

        public Builder setNotificationEmails(List<String> serverAlertAddress) {
            this.notificationEmails = serverAlertAddress;
            return this;
        }

        public MailConfiguration build() {
            return new MailConfiguration(this);
        }
    }
}