package com.atlassian.crowd.service.cluster;

import com.atlassian.annotations.ExperimentalApi;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Provides data about clustering configuration
 *
 * @since 2.12.0
 */
public interface ClusterService {
    /**
     * @return {@code true} if clustering is available, otherwise {@code false}
     */
    boolean isAvailable();

    /**
     * Retrieves a cluster-wide unique identifier for this node.
     * <p>
     * The value is guaranteed to be unique within the cluster. If the cluster is restarted, every node's ID will
     * still be unique but will likely not be the same as the previous value.
     *
     * @return a cluster-wide unique opaque identifier for this node
     * @see ClusterNode#getNodeId()
     */
    @Nonnull
    String getNodeId();

    /**
     * Retrieves details for this node
     *
     * @return details for this node or empty optional if clustering is unavailable
     */
    @ExperimentalApi
    Optional<ClusterNode> getClusterNode();

    /**
     * @return details about the cluster and its {@link ClusterNode nodes}
     */
    @Nonnull
    ClusterInformation getInformation();
}
