package com.atlassian.crowd.manager.sso;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.model.sso.KeyCertificatePair;

import java.util.Optional;

/**
 * A service for managing global SAML configuration.
 *
 * @since 3.4.0
 */
@Internal
public interface CrowdSamlConfigurationServiceInternal extends CrowdSamlConfigurationService {
    /**
     * @return Private key/certificate pair used to sign/verify if found, none otherwise
     */
    Optional<KeyCertificatePair> getKeyCertificatePairToSign();
}
