package com.atlassian.crowd.manager.mail;

import com.atlassian.fugue.Pair;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MailSendException extends Exception {
    private static final String MAIL_SEND_EXCEPTION_MESSAGE = "Could not send email to ";

    /**
     * @deprecated since 3.7 use {@link #MailSendException(EmailMessage)}
     */
    @Deprecated
    public MailSendException(InternetAddress email) {
        super(MAIL_SEND_EXCEPTION_MESSAGE + email);
    }

    /**
     * @deprecated since 3.7 use {@link #MailSendException(EmailMessage, Throwable)}
     */
    @Deprecated
    public MailSendException(InternetAddress email, Throwable cause) {
        super(MAIL_SEND_EXCEPTION_MESSAGE + email + ": " + cause.getMessage(), cause);
    }

    public MailSendException(EmailMessage email) {
        super(errorMessage(email));
    }

    public MailSendException(EmailMessage email, Throwable cause) {
        super(errorMessage(email) + ": " + cause.getMessage(), cause);
    }

    public MailSendException(Throwable cause) {
        super(cause);
    }

    private static String errorMessage(EmailMessage email) {
        final List<Pair<Address, Message.RecipientType>> recipients = new ArrayList<>();
        email.getTo().forEach(recipient -> recipients.add(Pair.pair(recipient, Message.RecipientType.TO)));
        email.getCc().forEach(recipient -> recipients.add(Pair.pair(recipient, Message.RecipientType.CC)));
        email.getBcc().forEach(recipient -> recipients.add(Pair.pair(recipient, Message.RecipientType.BCC)));
        return String.format("Could not send email to %d recipient(s) (%s)",
                recipients.size(),
                recipients.stream()
                        .map(recipientInfo -> String.format("%s: %s", recipientInfo.right(), recipientInfo.left()))
                        .collect(Collectors.joining(", ")));
    }
}
