package com.atlassian.crowd.audit;

/**
 * Represents a set of operations which should be executed on behalf of {@link AuditLogAuthor}.
 * @param <T> result of the set of operations
 */
@FunctionalInterface
public interface AuditLogContextCallback<T> {

    /**
     * Operations which should be executed in given AuthorContext
     * {@link AuditLogContext}
     * {@link AuditLogAuthor}
     * @throws Exception the exception thrown from the callback (if any)
     * @return result of the set of operations
     */
    T execute() throws Exception;
}
