/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.BasicAuthFilter;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import junit.framework.TestCase;

public abstract class RestCrowdServiceAcceptanceTestCase
extends TestCase {
    protected static final String APPLICATION_NAME = "crowd";
    protected static final String APPLICATION_PASSWORD = "qybhDMZh";
    protected static final String GROUPS_RESOURCE = "group";
    protected static final String ATTRIBUTES_RESOURCE = "attribute";
    protected static final String USERS_RESOURCE = "user";
    protected static final String MEMBERSHIPS_RESOURCE = "membership";
    protected static final String AUTHENTICATION_RESOURCE = "authentication";
    protected static final String SESSION_RESOURCE = "session";
    protected static final String REST_SERVICE_NAME = "usermanagement";
    private static final String USERNAME_PARAM = "username";
    private RestServer restServer = RestServerImpl.INSTANCE;

    protected RestCrowdServiceAcceptanceTestCase(String name) {
        this(name, (RestServer)RestServerImpl.INSTANCE);
    }

    protected RestCrowdServiceAcceptanceTestCase(String name, RestServer restServer) {
        super(name);
        if (restServer == null) {
            throw new NullPointerException("restServer");
        }
        this.restServer = restServer;
    }

    public void setUp() throws Exception {
        this.restServer.before();
    }

    public final void setRestServer(RestServer restServer) {
        this.restServer = restServer;
    }

    protected UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((String)("http://" + this.restServer.getHost() + "/")).port(this.restServer.getPort()).path(this.restServer.getContextPath()).path("rest").path(REST_SERVICE_NAME).path("latest");
    }

    protected WebResource getRootWebResource(String applicationName, String password) {
        URI baseUri = this.getBaseUriBuilder().build(new Object[0]);
        return this.getWebResource(applicationName, password, baseUri);
    }

    protected WebResource getWebResource(String applicationName, String password, URI uri) {
        Client client = Client.create();
        client.addFilter((ClientFilter)new BasicAuthFilter(applicationName, password));
        client = this.restServer.decorateClient(client);
        return client.resource(uri);
    }

    protected static String statusToString(Response.Status status) {
        return String.format("%d (%s)", status.getStatusCode(), status.toString());
    }

    protected UserEntity authenticateUser(String username, String password) {
        URI uri = this.getBaseUriBuilder().path(AUTHENTICATION_RESOURCE).queryParam(USERNAME_PARAM, new Object[]{"{username}"}).build(new Object[]{username});
        WebResource webResource = this.getWebResource(APPLICATION_NAME, APPLICATION_PASSWORD, uri);
        return (UserEntity)webResource.post(UserEntity.class, (Object)new PasswordEntity(password, null));
    }
}

