/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class GroupsResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String USER_PATH = "user";
    private static final String DIRECT_PATH = "direct";
    private static final String NESTED_PATH = "nested";
    private static final String GROUPNAME_PARAM = "groupname";
    private static final String CHILD_GROUPNAME_PARAM = "child-groupname";
    private static final String PARENT_GROUPNAME_PARAM = "parent-groupname";
    private static final String USERNAME_PARAM = "username";
    private static final String CHILD_GROUP_PATH = "child-group";
    private static final String PARENT_GROUP_PATH = "parent-group";
    private static final String START_INDEX_PARAM = "start-index";
    private static final String MAX_RESULT_PARAM = "max-results";
    private static final String USERNAME1 = "admin";
    private static final String USERNAME2 = "eeeep";
    private static final String USERNAME3 = "penny";
    private static final String GROUP1 = "badgers";
    private static final String GROUP2 = "crowd-administrators";
    private static final String GROUP3 = "crowd-testers";
    private static final String GROUP4 = "crowd-users";
    private static final String GROUP5 = "animals";
    private static final String GROUP6 = "birds";
    private static final String GROUP7 = "\u5bff\u53f8";
    private static final String GROUP7_URLENCODED = "%E5%AF%BF%E5%8F%B8";
    private static final String EMAIL1 = "bob@example.net";
    private static final String EMAIL2 = "doflynn@atlassian.com";

    public GroupsResourceTest(String name) {
        super(name);
    }

    public GroupsResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntity restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)GROUP1, (String)restGroup.getName());
        GroupsResourceTest.assertEquals((String)"A group for badgers", (String)restGroup.getDescription());
        GroupsResourceTest.assertEquals((boolean)true, (boolean)restGroup.isActive());
        GroupsResourceTest.assertEquals((String)webResource.toString(), (String)restGroup.getLink().getHref().toString());
    }

    public void testGetGroup_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, GROUP1).queryParam("expand", "attributes");
        GroupEntity restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)GROUP1, (String)restGroup.getName());
        GroupsResourceTest.assertEquals((String)"A group for badgers", (String)restGroup.getDescription());
        GroupsResourceTest.assertEquals((boolean)true, (boolean)restGroup.isActive());
        GroupsResourceTest.assertEquals((String)webResource.toString(), (String)(restGroup.getLink().getHref().toString() + "&expand=attributes"));
        Map attributes = EntityTranslator.toAttributes((MultiValuedAttributeEntityList)restGroup.getAttributes());
        GroupsResourceTest.assertEquals((int)1, (int)attributes.size());
        GroupsResourceTest.assertEquals(Collections.singleton("hollow"), attributes.get("secret-location"));
    }

    public void testGetGroup_DoesNotExist() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, "beavers");
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testAddGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group");
        GroupTemplate groupTemplate = new GroupTemplate("beavers");
        groupTemplate.setDescription("A group for beavers");
        groupTemplate.setActive(false);
        webResource.post((Object)EntityTranslator.toGroupEntity((Group)groupTemplate, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI()));
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, "beavers");
        GroupEntity restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)"beavers", (String)restGroup.getName());
        GroupsResourceTest.assertEquals((String)"A group for beavers", (String)restGroup.getDescription());
        GroupsResourceTest.assertFalse((boolean)restGroup.isActive());
    }

    public void testAddGroup_Unicode() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group");
        GroupTemplate groupTemplate = new GroupTemplate(GROUP7);
        groupTemplate.setDescription("A group with unicode characters in the name");
        groupTemplate.setActive(false);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)EntityTranslator.toGroupEntity((Group)groupTemplate, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI()));
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, GROUP7);
        String encodedURI = webResource.getURI().toASCIIString();
        GroupsResourceTest.assertTrue((String)("URI should end with '%E5%AF%BF%E5%8F%B8' but was: " + encodedURI), (boolean)encodedURI.endsWith(GROUP7_URLENCODED));
        GroupsResourceTest.assertEquals((Object)webResource.getURI(), (Object)response.getLocation());
        GroupEntity restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)GROUP7, (String)restGroup.getName());
        GroupsResourceTest.assertEquals((String)"A group with unicode characters in the name", (String)restGroup.getDescription());
        GroupsResourceTest.assertFalse((boolean)restGroup.isActive());
    }

    public void testUpdateGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntity restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupTemplate template = new GroupTemplate((Group)EntityTranslator.toGroup((GroupEntity)restGroup));
        template.setActive(false);
        template.setDescription("Badgers Rock!");
        webResource.put((Object)EntityTranslator.toGroupEntity((Group)template, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI()));
        restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)"Badgers Rock!", (String)restGroup.getDescription());
        GroupsResourceTest.assertFalse((boolean)restGroup.isActive());
    }

    public void testUpdateGroup_BadDetails() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntity restGroup = (GroupEntity)webResource.get(GroupEntity.class);
        GroupTemplate template = new GroupTemplate((Group)EntityTranslator.toGroup((GroupEntity)restGroup));
        template.setName("cats");
        template.setActive(false);
        template.setDescription("Cats are cool!");
        ClientResponse response = (ClientResponse)webResource.put(ClientResponse.class, (Object)EntityTranslator.toGroupEntity((Group)template, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI()));
        this.assertError(response, 400, ErrorEntity.ErrorReason.INVALID_GROUP);
    }

    public void testDeleteGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").queryParam(GROUPNAME_PARAM, GROUP1);
        webResource.delete();
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testStoreGroupAttributes() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path("attribute").queryParam(GROUPNAME_PARAM, GROUP1);
        MultiValuedAttributeEntity attribute = new MultiValuedAttributeEntity("special-food-requirements", (Collection)Sets.newHashSet((Object[])new String[]{"stoats", "voles", "marmots"}), null);
        MultiValuedAttributeEntityList restAttributes = new MultiValuedAttributeEntityList(Collections.singletonList(attribute), null);
        webResource.post((Object)restAttributes);
        MultiValuedAttributeEntityList attributeEntityList = (MultiValuedAttributeEntityList)webResource.get(MultiValuedAttributeEntityList.class);
        Map attributes = EntityTranslator.toAttributes((MultiValuedAttributeEntityList)attributeEntityList);
        GroupsResourceTest.assertEquals((int)2, (int)attributes.size());
        GroupsResourceTest.assertEquals(Collections.singleton("hollow"), attributes.get("secret-location"));
        Set foods = (Set)attributes.get("special-food-requirements");
        GroupsResourceTest.assertEquals((int)3, (int)foods.size());
        GroupsResourceTest.assertTrue((boolean)foods.containsAll(Sets.newHashSet((Object[])new String[]{"stoats", "voles", "marmots"})));
    }

    public void testDeleteGroupAttribute() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path("attribute").queryParam(GROUPNAME_PARAM, GROUP1).queryParam("attributename", "secret-location");
        webResource.delete();
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path("attribute").queryParam(GROUPNAME_PARAM, GROUP1);
        MultiValuedAttributeEntityList attributeEntityList = (MultiValuedAttributeEntityList)webResource.get(MultiValuedAttributeEntityList.class);
        Map attributes = EntityTranslator.toAttributes((MultiValuedAttributeEntityList)attributeEntityList);
        GroupsResourceTest.assertTrue((boolean)attributes.isEmpty());
        GroupsResourceTest.assertNull(attributes.get("secret-location"));
    }

    public void testGetDirectUsers() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1);
        UserEntityList users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
        GroupsResourceTest.assertContainsName(users, USERNAME2);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP4);
        users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)0, (int)users.size());
    }

    public void testGetDirectUsers_Limit1() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam(START_INDEX_PARAM, "0").queryParam(MAX_RESULT_PARAM, "1");
        UserEntityList users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
    }

    public void testGetDirectUsers_Limit2() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam(START_INDEX_PARAM, "1").queryParam(MAX_RESULT_PARAM, "1");
        UserEntityList users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME2);
    }

    public void testGetDirectUsers_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam("expand", USER_PATH);
        UserEntityList users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
        GroupsResourceTest.assertContainsEmail(users, EMAIL1);
        GroupsResourceTest.assertContainsName(users, USERNAME2);
        GroupsResourceTest.assertContainsEmail(users, EMAIL2);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP4);
        users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)0, (int)users.size());
    }

    public void testAddDirectUser() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2);
        Link link = LinkUriHelper.buildUserLink((URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI(), (String)USERNAME2);
        UserEntity user = UserEntity.newMinimalUserEntity((String)USERNAME2, null, (Link)link);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)user);
        GroupsResourceTest.assertEquals((int)201, (int)response.getStatus());
        GroupsResourceTest.assertEquals((Object)webResource.queryParam(USERNAME_PARAM, USERNAME2).getURI(), (Object)response.getLocation());
    }

    public void testAddDirectUser_NoUser() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2);
        Link link = LinkUriHelper.buildUserLink((URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI(), (String)USERNAME2);
        UserEntity user = UserEntity.newMinimalUserEntity((String)"non-existent-user", null, (Link)link);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)user);
        this.assertError(response, 400, ErrorEntity.ErrorReason.USER_NOT_FOUND);
    }

    public void testAddDirectUser_NoGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, "non-existant-group");
        Link link = LinkUriHelper.buildUserLink((URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI(), (String)USERNAME2);
        UserEntity user = UserEntity.newMinimalUserEntity((String)USERNAME2, null, (Link)link);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)user);
        this.assertError(response, 404, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testGetDirectUsers_User() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam(USERNAME_PARAM, USERNAME1);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        GroupsResourceTest.assertEquals((String)USERNAME1, (String)user.getName());
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP4);
        webResource.get(UserEntityList.class);
    }

    public void testDeleteDirectUser() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2).queryParam(USERNAME_PARAM, USERNAME1);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        GroupsResourceTest.assertEquals((int)200, (int)response.getStatus());
        response = (ClientResponse)webResource.delete(ClientResponse.class);
        GroupsResourceTest.assertEquals((int)204, (int)response.getStatus());
        response = (ClientResponse)webResource.get(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND);
    }

    public void testGetNestedUsers() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1);
        UserEntityList users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
        GroupsResourceTest.assertContainsName(users, USERNAME2);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP4);
        users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
        GroupsResourceTest.assertContainsName(users, USERNAME2);
    }

    public void testGetNestedUsers_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam("expand", USER_PATH);
        UserEntityList users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
        GroupsResourceTest.assertContainsEmail(users, EMAIL1);
        GroupsResourceTest.assertContainsName(users, USERNAME2);
        GroupsResourceTest.assertContainsEmail(users, EMAIL2);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP4).queryParam("expand", USER_PATH);
        users = (UserEntityList)webResource.get(UserEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)users.size());
        GroupsResourceTest.assertContainsName(users, USERNAME1);
        GroupsResourceTest.assertContainsEmail(users, EMAIL1);
        GroupsResourceTest.assertContainsName(users, USERNAME2);
        GroupsResourceTest.assertContainsEmail(users, EMAIL2);
    }

    public void testGetNestedUsers_User() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam(USERNAME_PARAM, USERNAME1);
        UserEntity user = (UserEntity)webResource.get(UserEntity.class);
        GroupsResourceTest.assertEquals((String)USERNAME1, (String)user.getName());
    }

    public void testGetNestedUsers_NoUser() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(USER_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam(USERNAME_PARAM, USERNAME3);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND);
    }

    public void testGetDirectParentGroups() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertContainsName(groups, GROUP4);
        GroupsResourceTest.assertNotExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP3);
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP2);
        GroupsResourceTest.assertNotExpanded(groups);
    }

    public void testGetDirectParentGroups_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam("expand", "group");
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertContainsName(groups, GROUP4);
        GroupsResourceTest.assertExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP3).queryParam("expand", "group");
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP2);
        GroupsResourceTest.assertExpanded(groups);
    }

    public void testAddDirectParentGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)GROUP2, null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        GroupsResourceTest.assertEquals((int)201, (int)response.getStatus());
        GroupsResourceTest.assertEquals((Object)webResource.queryParam(PARENT_GROUPNAME_PARAM, GROUP2).getURI(), (Object)response.getLocation());
    }

    public void testAddDirectParentGroup_NoGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, "does-not-exist");
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)GROUP2, null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        this.assertError(response, 404, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testAddDirectParentGroup_NoParent() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)"does-not-exist", null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        this.assertError(response, 400, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testGetNestedParentGroups() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1);
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)3, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP2);
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertContainsName(groups, GROUP4);
        GroupsResourceTest.assertNotExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP3);
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP2);
        GroupsResourceTest.assertNotExpanded(groups);
    }

    public void testGetNestedParentGroups_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam("expand", "group");
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)3, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP2);
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertContainsName(groups, GROUP4);
        GroupsResourceTest.assertExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP3).queryParam("expand", "group");
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP2);
        GroupsResourceTest.assertExpanded(groups);
    }

    public void testGetNestedParentGroups_Group() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP1).queryParam(PARENT_GROUPNAME_PARAM, GROUP2);
        GroupEntity group = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)GROUP2, (String)group.getName());
    }

    public void testGetNestedParentGroups_NoGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(PARENT_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP4).queryParam(PARENT_GROUPNAME_PARAM, GROUP2);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND);
    }

    public void testGetDirectChildGroups() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2);
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertNotExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP4);
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP1);
        GroupsResourceTest.assertNotExpanded(groups);
    }

    public void testGetDirectChildGroups_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2).queryParam("expand", "group");
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP4).queryParam("expand", "group");
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP1);
        GroupsResourceTest.assertExpanded(groups);
    }

    public void testAddDirectChildGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2);
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)GROUP1, null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        GroupsResourceTest.assertEquals((int)201, (int)response.getStatus());
        GroupsResourceTest.assertEquals((Object)webResource.queryParam(CHILD_GROUPNAME_PARAM, GROUP1).getURI(), (Object)response.getLocation());
    }

    public void testAddDirectChildGroup_NoGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, "does-not-exist");
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)GROUP1, null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        this.assertError(response, 404, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testAddDirectChildGroup_NoChild() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2);
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)"does-not-exist", null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        this.assertError(response, 400, ErrorEntity.ErrorReason.GROUP_NOT_FOUND);
    }

    public void testAddDirectChildGroup_NoNestedGroups() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP5);
        GroupEntity group = GroupEntity.newMinimalGroupEntity((String)GROUP6, null, (URI)this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").getURI());
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)group);
        GroupsResourceTest.assertEquals((int)403, (int)response.getStatus());
    }

    public void testGetDirectChildGroups_Group() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2).queryParam(CHILD_GROUPNAME_PARAM, GROUP3);
        GroupEntity group = (GroupEntity)webResource.get(GroupEntity.class);
        GroupsResourceTest.assertEquals((String)GROUP3, (String)group.getName());
    }

    public void testDeleteDirectChildGroup() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2).queryParam(CHILD_GROUPNAME_PARAM, GROUP3);
        ClientResponse response = (ClientResponse)webResource.delete(ClientResponse.class);
        GroupsResourceTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testDeleteDirectChildGroup_NoParent() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, "does-not-exist").queryParam(CHILD_GROUPNAME_PARAM, GROUP3);
        ClientResponse response = (ClientResponse)webResource.delete(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND);
    }

    public void testDeleteDirectChildGroup_NoChild() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(DIRECT_PATH).queryParam(GROUPNAME_PARAM, GROUP2).queryParam(CHILD_GROUPNAME_PARAM, "does-not-exist");
        ClientResponse response = (ClientResponse)webResource.delete(ClientResponse.class);
        this.assertError(response, 404, ErrorEntity.ErrorReason.MEMBERSHIP_NOT_FOUND);
    }

    public void testGetNestedChildGroups() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP2);
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertContainsName(groups, GROUP1);
        GroupsResourceTest.assertNotExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP4);
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP1);
        GroupsResourceTest.assertNotExpanded(groups);
    }

    public void testGetNestedChildGroups_Expanded() {
        WebResource webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP2).queryParam("expand", "group");
        GroupEntityList groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)2, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP3);
        GroupsResourceTest.assertContainsName(groups, GROUP1);
        GroupsResourceTest.assertExpanded(groups);
        webResource = this.getRootWebResource(APPLICATION_NAME, "qybhDMZh").path("group").path(CHILD_GROUP_PATH).path(NESTED_PATH).queryParam(GROUPNAME_PARAM, GROUP4).queryParam("expand", "group");
        groups = (GroupEntityList)webResource.get(GroupEntityList.class);
        GroupsResourceTest.assertEquals((int)1, (int)groups.size());
        GroupsResourceTest.assertContainsName(groups, GROUP1);
        GroupsResourceTest.assertExpanded(groups);
    }

    private static void assertContainsName(UserEntityList expectedList, String name) {
        for (UserEntity entity : expectedList) {
            if (!name.equals(entity.getName())) continue;
            return;
        }
        GroupsResourceTest.fail((String)"expectedList does not contain: 'name'");
    }

    private static void assertContainsEmail(UserEntityList expectedList, String email) {
        for (UserEntity entity : expectedList) {
            if (!email.equals(entity.getEmail())) continue;
            return;
        }
        GroupsResourceTest.fail((String)"expectedList does not contain: 'email'");
    }

    private static void assertContainsName(GroupEntityList expectedList, String name) {
        for (GroupEntity entity : expectedList) {
            if (!name.equals(entity.getName())) continue;
            return;
        }
        GroupsResourceTest.fail((String)"expectedList does not contain: 'name'");
    }

    private static void assertExpanded(GroupEntityList expectedList) {
        for (GroupEntity entity : expectedList) {
            if (entity.getType() != null || entity.getDescription() != null) continue;
            GroupsResourceTest.fail((String)("Group " + entity.getName() + " is not expanded"));
        }
    }

    private static void assertNotExpanded(GroupEntityList expectedList) {
        for (GroupEntity entity : expectedList) {
            if (entity.getType() == null && entity.getDescription() == null) continue;
            GroupsResourceTest.fail((String)("Group " + entity.getName() + " is expanded"));
        }
    }

    private void assertError(ClientResponse response, int statusCode, ErrorEntity.ErrorReason reason) {
        GroupsResourceTest.assertEquals((int)statusCode, (int)response.getStatus());
        ErrorEntity error = (ErrorEntity)response.getEntity(ErrorEntity.class);
        GroupsResourceTest.assertEquals((Object)reason, (Object)error.getReason());
    }
}

