/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.usermanagement;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableMembership;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.GroupsController;
import com.atlassian.crowd.plugin.rest.service.controller.MembershipsController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.crowd.plugin.rest.util.EntityExpansionUtil;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="group")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@AnonymousAllowed
public class GroupsResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(GroupsResource.class);
    private static final String CHILD_GROUP_NAME_PARAM = "child-groupname";
    private final GroupsController groupsController;
    private final MembershipsController membershipsController;

    public GroupsResource(GroupsController groupsController, MembershipsController membershipsController) {
        this.groupsController = groupsController;
        this.membershipsController = membershipsController;
    }

    private Link groupLinkTemplate() {
        return LinkUriHelper.buildGroupLink(this.uriInfo.getBaseUri(), "");
    }

    @GET
    public Response getGroup(@QueryParam(value="groupname") String groupName) throws GroupNotFoundException {
        if (groupName == null) {
            throw new GroupNotFoundException("");
        }
        GroupEntity group = this.groupsController.findGroupByName(groupName, this.expandAttributes(), this.getBaseUri());
        return Response.ok((Object)group).build();
    }

    @POST
    public Response addGroup(GroupEntity restGroup) throws GroupNotFoundException, InvalidGroupException, ApplicationPermissionException, OperationFailedException {
        GroupEntity createdGroupEntity = this.groupsController.addGroup(restGroup, this.groupLinkTemplate());
        return Response.created((URI)LinkUriHelper.buildGroupUri(this.getBaseUri(), createdGroupEntity.getName())).entity((Object)createdGroupEntity).build();
    }

    @PUT
    public Response updateGroup(@QueryParam(value="groupname") String groupName, GroupEntity restGroup) throws GroupNotFoundException, InvalidGroupException, ApplicationPermissionException, OperationFailedException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)groupName, (CharSequence)restGroup.getName())) {
            throw new InvalidGroupException((Group)EntityTranslator.toGroup(restGroup), "The names of the resource location <" + this.uriInfo + "> and object <" + restGroup.getName() + "> are not equal");
        }
        GroupEntity updatedGroup = this.groupsController.updateGroup(restGroup, this.getBaseUri());
        return Response.ok((Object)updatedGroup).build();
    }

    @DELETE
    public Response removeGroup(@QueryParam(value="groupname") String groupname) throws GroupNotFoundException, ApplicationPermissionException, OperationFailedException {
        this.groupsController.removeGroup(groupname);
        return Response.noContent().build();
    }

    @GET
    @Path(value="attribute")
    public Response getGroupAttributes(@QueryParam(value="groupname") String groupName) throws GroupNotFoundException {
        GroupEntity group = this.groupsController.findGroupByName(groupName, true, this.getBaseUri());
        return Response.ok((Object)group.getAttributes()).build();
    }

    @POST
    @Path(value="attribute")
    public Response storeGroupAttributes(@QueryParam(value="groupname") String groupname, MultiValuedAttributeEntityList attributes) throws GroupNotFoundException, ApplicationPermissionException, OperationFailedException {
        this.groupsController.storeGroupAttributes(groupname, attributes);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="attribute")
    public Response deleteGroupAttribute(@QueryParam(value="groupname") String groupname, @QueryParam(value="attributename") String attributeName) throws GroupNotFoundException, ApplicationPermissionException, OperationFailedException {
        this.groupsController.removeGroupAttributes(groupname, attributeName);
        return Response.noContent().build();
    }

    static boolean unspecified(String s, String name) {
        if (s == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new IllegalArgumentException(name + " may not be blank");
        }
        return false;
    }

    @GET
    @Path(value="user/direct")
    public Response getDirectMembersOfGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults) throws MembershipNotFoundException, GroupNotFoundException {
        if (GroupsResource.unspecified(username, "username")) {
            UserEntityList directUsers = this.groupsController.getDirectUsers(groupName, this.expandUsers(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directUsers).build();
        }
        UserEntity directUser = this.groupsController.getDirectUser(groupName, username, this.getBaseUri());
        return Response.ok((Object)directUser).build();
    }

    @POST
    @Path(value="user/direct")
    public Response addUserAsDirectGroupMember(@QueryParam(value="groupname") String groupName, UserEntity user) throws GroupNotFoundException, OperationFailedException, ApplicationPermissionException, MembershipAlreadyExistsException {
        this.notNull(groupName, "groupname argument cannot be null");
        this.notNull(user, "user is not passed as the request body");
        this.notNull(user.getName(), "user.name cannot be null");
        try {
            this.groupsController.addDirectUser(groupName, user.getName());
            return Response.created((URI)LinkUriHelper.buildDirectUserGroupUri(this.getBaseUri(), groupName, user.getName())).build();
        }
        catch (UserNotFoundException e) {
            ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
    }

    @DELETE
    @Path(value="user/direct")
    public Response removeDirectGroupMembership(@QueryParam(value="groupname") String groupName, @QueryParam(value="username") String username) throws GroupNotFoundException, MembershipNotFoundException, UserNotFoundException, OperationFailedException, ApplicationPermissionException {
        this.groupsController.deleteDirectUser(groupName, username);
        return Response.noContent().build();
    }

    @GET
    @Path(value="user/nested")
    public Response getNestedMembersOfGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults) throws MembershipNotFoundException, GroupNotFoundException {
        if (GroupsResource.unspecified(username, "username")) {
            UserEntityList nestedUsers = this.groupsController.getNestedUsers(groupName, this.expandUsers(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)nestedUsers).build();
        }
        UserEntity nestedUser = this.groupsController.getNestedUser(groupName, username, this.getBaseUri());
        return Response.ok((Object)nestedUser).build();
    }

    @GET
    @Path(value="parent-group/direct")
    public Response getDirectParentsOfGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="child-groupname") String childGroupName, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults) throws MembershipNotFoundException {
        if (GroupsResource.unspecified(childGroupName, CHILD_GROUP_NAME_PARAM)) {
            GroupEntityList directParentGroups = this.groupsController.getDirectParentGroups(groupName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directParentGroups).build();
        }
        GroupEntity directParentGroup = this.groupsController.getDirectParentGroup(groupName, childGroupName, this.getBaseUri());
        return Response.ok((Object)directParentGroup).build();
    }

    @POST
    @Path(value="parent-group/direct")
    public Response addDirectParentGroupMembership(@QueryParam(value="groupname") String groupName, GroupEntity parentGroup) throws InvalidMembershipException, OperationFailedException, ApplicationPermissionException, MembershipAlreadyExistsException {
        try {
            this.groupsController.addDirectParentGroup(groupName, parentGroup.getName());
            return Response.created((URI)LinkUriHelper.buildDirectParentGroupUri(this.getBaseUri(), groupName, parentGroup.getName())).build();
        }
        catch (GroupNotFoundException e) {
            ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
            if (e.getGroupName().equals(groupName)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorEntity).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
    }

    @GET
    @Path(value="parent-group/nested")
    public Response getNestedParentGroups(@QueryParam(value="groupname") String groupName, @QueryParam(value="parent-groupname") String parentGroupName, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults) throws MembershipNotFoundException {
        if (GroupsResource.unspecified(parentGroupName, "parent-groupname")) {
            GroupEntityList nestedParentGroups = this.groupsController.getNestedParentGroups(groupName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)nestedParentGroups).build();
        }
        GroupEntity nestedParentGroup = this.groupsController.getNestedParentGroup(groupName, parentGroupName, this.getBaseUri());
        return Response.ok((Object)nestedParentGroup).build();
    }

    @GET
    @Path(value="child-group/direct")
    public Response getDirectChildrenOfGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="child-groupname") String childGroupName, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults) throws MembershipNotFoundException {
        if (GroupsResource.unspecified(childGroupName, CHILD_GROUP_NAME_PARAM)) {
            GroupEntityList directChildGroups = this.groupsController.getDirectChildGroups(groupName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directChildGroups).build();
        }
        GroupEntity directChildGroup = this.groupsController.getDirectChildGroup(groupName, childGroupName, this.getBaseUri());
        return Response.ok((Object)directChildGroup).build();
    }

    @POST
    @Path(value="child-group/direct")
    public Response addDirectChildGroupMembership(@QueryParam(value="groupname") String groupName, GroupEntity childGroup) throws InvalidMembershipException, ApplicationPermissionException, OperationFailedException, MembershipAlreadyExistsException {
        try {
            this.groupsController.addDirectChildGroup(groupName, childGroup.getName());
            return Response.created((URI)LinkUriHelper.buildDirectChildGroupUri(this.getBaseUri(), groupName, childGroup.getName())).build();
        }
        catch (GroupNotFoundException e) {
            ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), e.getMessage());
            if (e.getGroupName().equals(groupName)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorEntity).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
    }

    @DELETE
    @Path(value="child-group/direct")
    public Response removeDirectChildGroupMembership(@QueryParam(value="groupname") String groupName, @QueryParam(value="child-groupname") String childGroupName) throws MembershipNotFoundException, GroupNotFoundException, ApplicationPermissionException, OperationFailedException {
        this.groupsController.deleteDirectChildGroup(groupName, childGroupName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="child-group/nested")
    public Response getNestedChildrenOfGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="child-groupname") String childGroupName, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults) throws MembershipNotFoundException {
        if (GroupsResource.unspecified(childGroupName, CHILD_GROUP_NAME_PARAM)) {
            GroupEntityList nestedChildGroups = this.groupsController.getNestedChildGroups(groupName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)nestedChildGroups).build();
        }
        GroupEntity nestedChildGroup = this.groupsController.getNestedChildGroup(groupName, childGroupName, this.getBaseUri());
        return Response.ok((Object)nestedChildGroup).build();
    }

    @GET
    @Path(value="membership")
    @Produces(value={"application/xml"})
    public Response getAllMemberships(@Context Request request) throws NoSuchAlgorithmException {
        MembershipsController.PreparedResponse pr = this.membershipsController.prepareQuery();
        if (pr.groupCount() > 20) {
            StreamingOutput memberships = pr.stream();
            return Response.ok((Object)memberships).type(MediaType.APPLICATION_XML_TYPE).build();
        }
        log.debug("Generating an entity tag for memberships for {}", (Object)this.getApplicationName());
        Iterable<ImmutableMembership> memberships = pr.getMemberships();
        EntityTag tag = new EntityTag(MembershipsController.tagFor(memberships), true);
        Response.ResponseBuilder rb = request.evaluatePreconditions(tag);
        if (rb != null) {
            return rb.build();
        }
        StreamingOutput membershipAsXmls = this.membershipsController.asXml(memberships);
        return Response.ok((Object)membershipAsXmls).tag(tag).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    private void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private boolean expandAttributes() {
        return EntityExpansionUtil.shouldExpandField(GroupEntity.class, "attributes", this.request);
    }

    private boolean expandGroups() {
        return EntityExpansionUtil.shouldExpandField(GroupEntityList.class, "groups", this.request);
    }

    private boolean expandUsers() {
        return EntityExpansionUtil.shouldExpandField(UserEntityList.class, "users", this.request);
    }
}

