/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.webhook.InvalidWebhookEndpointException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.webhook.Webhook;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class WebhooksController
extends AbstractResourceController {
    private final ApplicationService applicationService;

    @Inject
    public WebhooksController(@ComponentImport ApplicationService applicationService, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
    }

    public Webhook findWebhookById(long webhookId) throws ApplicationPermissionException, WebhookNotFoundException {
        Application application = this.getAuthenticatedApplication();
        return this.applicationService.findWebhookById(application, webhookId);
    }

    public Webhook registerWebhook(String endpointUrl, @Nullable String token) throws InvalidWebhookEndpointException {
        Application application = this.getAuthenticatedApplication();
        return this.applicationService.registerWebhook(application, endpointUrl, token);
    }

    public void unregisterWebhook(long webhookId) throws ApplicationPermissionException, WebhookNotFoundException {
        Application application = this.getAuthenticatedApplication();
        this.applicationService.unregisterWebhook(application, webhookId);
    }
}

