/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.IncrementalSynchronisationNotAvailableException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.rest.entity.EventEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.EventsController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="event")
@AnonymousAllowed
@Produces(value={"application/xml", "application/json"})
public class EventsResource
extends AbstractResource {
    private final EventsController eventsController;

    public EventsResource(EventsController eventsController) {
        this.eventsController = eventsController;
    }

    @GET
    public Response getEventCookie() {
        return Response.ok((Object)this.eventsController.getCurrentEventToken(this.getApplicationName())).build();
    }

    @GET
    @Path(value="{eventToken}")
    public Response getEvents(@PathParam(value="eventToken") String eventToken) throws EventTokenExpiredException, IncrementalSynchronisationNotAvailableException, OperationFailedException {
        EventEntityList events = this.eventsController.getEventsSince(this.getApplicationName(), eventToken, this.getBaseUri());
        return Response.ok((Object)events).build();
    }
}

