/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.webhook.InvalidWebhookEndpointException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.webhook.Webhook;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import javax.annotation.Nullable;

public class WebhooksController
extends AbstractResourceController {
    public WebhooksController(ApplicationService applicationService, ApplicationManager applicationManager) {
        super(applicationService, applicationManager);
    }

    public Webhook findWebhookById(String applicationName, long webhookId) throws ApplicationPermissionException, WebhookNotFoundException {
        Application application = this.getApplication(applicationName);
        return this.applicationService.findWebhookById(application, webhookId);
    }

    public Webhook registerWebhook(String applicationName, String endpointUrl, @Nullable String token) throws InvalidWebhookEndpointException {
        Application application = this.getApplication(applicationName);
        return this.applicationService.registerWebhook(application, endpointUrl, token);
    }

    public void unregisterWebhook(String applicationName, long webhookId) throws ApplicationPermissionException, WebhookNotFoundException {
        Application application = this.getApplication(applicationName);
        this.applicationService.unregisterWebhook(application, webhookId);
    }
}

