/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.SearchRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.SearchController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.crowd.plugin.rest.service.util.CacheControl;
import com.atlassian.crowd.plugin.rest.util.EntityExpansionUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="search")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@AnonymousAllowed
public class SearchResource
extends AbstractResource {
    private static final String GROUP_ENTITY_TYPE = "group";
    private static final String USER_ENTITY_TYPE = "user";
    private static final String DEFAULT_SEARCH_RESULT_SIZE_STRING = "1000";
    private final SearchController searchController;

    public SearchResource(SearchController searchController) {
        this.searchController = searchController;
    }

    @POST
    public Response search(@QueryParam(value="entity-type") String entityType, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, SearchRestrictionEntity searchRestriction) {
        String applicationName = this.getApplicationName();
        if (entityType == null) {
            throw new IllegalArgumentException("entity-type query parameter required.");
        }
        if (GROUP_ENTITY_TYPE.equalsIgnoreCase(entityType)) {
            boolean expandGroup = EntityExpansionUtil.shouldExpandField(GroupEntityList.class, "groups", this.request);
            GroupEntityList groupEntityList = this.searchController.searchGroups(applicationName, searchRestriction, maxResults, startIndex, expandGroup, this.uriInfo.getBaseUri());
            return Response.ok((Object)groupEntityList).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (USER_ENTITY_TYPE.equalsIgnoreCase(entityType)) {
            boolean expandUser = EntityExpansionUtil.shouldExpandField(UserEntityList.class, "users", this.request);
            UserEntityList userEntityList = this.searchController.searchUsers(applicationName, searchRestriction, maxResults, startIndex, expandUser, this.uriInfo.getBaseUri());
            return Response.ok((Object)userEntityList).cacheControl(CacheControl.NO_CACHE).build();
        }
        throw new IllegalArgumentException("Unknown type: " + entityType);
    }

    @GET
    public Response search(@QueryParam(value="entity-type") String entityType, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="") @QueryParam(value="restriction") String cqlSearchRestriction) {
        String applicationName = this.getApplicationName();
        if (entityType == null) {
            throw new IllegalArgumentException("entity-type query parameter required.");
        }
        if (GROUP_ENTITY_TYPE.equalsIgnoreCase(entityType)) {
            boolean expandGroup = EntityExpansionUtil.shouldExpandField(GroupEntityList.class, "groups", this.request);
            GroupEntityList groupEntityList = this.searchController.searchGroups(applicationName, cqlSearchRestriction, maxResults, startIndex, expandGroup, this.uriInfo.getBaseUri());
            return Response.ok((Object)groupEntityList).cacheControl(CacheControl.NO_CACHE).build();
        }
        if (USER_ENTITY_TYPE.equalsIgnoreCase(entityType)) {
            boolean expandUser = EntityExpansionUtil.shouldExpandField(UserEntityList.class, "users", this.request);
            UserEntityList userEntityList = this.searchController.searchUsers(applicationName, cqlSearchRestriction, maxResults, startIndex, expandUser, this.uriInfo.getBaseUri());
            return Response.ok((Object)userEntityList).cacheControl(CacheControl.NO_CACHE).build();
        }
        throw new IllegalArgumentException("Unknown type: " + entityType);
    }
}

