/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.SessionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenController {
    private final TokenAuthenticationManager tokenAuthenticationManager;

    public TokenController(TokenAuthenticationManager tokenAuthenticationManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public SessionEntity authenticateUser(String applicationName, String username, String password, Collection<ValidationFactorEntity> validationFactorEntities, URI baseUri) throws InvalidAuthenticationException, InactiveAccountException, ExpiredCredentialException, ApplicationAccessDeniedException, OperationFailedException {
        Token token;
        ValidationFactor[] validationFactors = TokenController.convertToValidationFactors(validationFactorEntities);
        UserAuthenticationContext authenticationContext = new UserAuthenticationContext(username, PasswordCredential.unencrypted((String)password), validationFactors, applicationName);
        try {
            token = this.tokenAuthenticationManager.authenticateUser(authenticationContext);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return this.createSession(token, applicationName, baseUri);
    }

    public SessionEntity authenticateUserWithoutValidatingPassword(String applicationName, String username, Collection<ValidationFactorEntity> validationFactorEntities, URI baseUri) throws InvalidAuthenticationException, InactiveAccountException, ExpiredCredentialException, ApplicationAccessDeniedException, OperationFailedException {
        Token token;
        ValidationFactor[] validationFactors = TokenController.convertToValidationFactors(validationFactorEntities);
        UserAuthenticationContext authenticationContext = new UserAuthenticationContext(username, null, validationFactors, applicationName);
        try {
            token = this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(authenticationContext);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return this.createSession(token, applicationName, baseUri);
    }

    public void invalidateToken(String token) {
        this.tokenAuthenticationManager.invalidateToken(token);
    }

    public SessionEntity validateToken(String applicationName, String token, Collection<ValidationFactorEntity> validationFactorEntities, URI baseUri) throws InvalidTokenException, ApplicationAccessDeniedException, OperationFailedException {
        ValidationFactor[] validationFactors = TokenController.convertToValidationFactors(validationFactorEntities);
        Token validatedToken = this.tokenAuthenticationManager.validateUserToken(token, validationFactors, applicationName);
        return this.createSession(validatedToken, applicationName, baseUri);
    }

    public UserEntity getUserFromToken(String token, String applicationName, URI baseUri) throws InvalidTokenException, OperationFailedException {
        User user;
        try {
            user = this.tokenAuthenticationManager.findUserByToken(token, applicationName);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return EntityTranslator.toUserEntity(user, LinkUriHelper.buildUserLink(baseUri, user.getName()));
    }

    private SessionEntity createSession(Token token, String applicationName, URI baseUri) {
        String username = token.getName();
        String randomHash = token.getRandomHash();
        Link userLink = LinkUriHelper.buildUserLink(baseUri, username);
        UserEntity user = UserEntity.newMinimalUserEntity(username, applicationName, userLink);
        Link link = LinkUriHelper.buildSessionLink(baseUri, randomHash);
        return new SessionEntity(randomHash, user, link);
    }

    private static ValidationFactor[] convertToValidationFactors(Collection<ValidationFactorEntity> validationFactorEntities) {
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>(validationFactorEntities.size());
        for (ValidationFactorEntity factor : validationFactorEntities) {
            validationFactors.add(new ValidationFactor(factor.getName(), factor.getValue()));
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }
}

