/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.plugin.rest.filter.AbstractBasicAuthenticationFilter;
import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicApplicationAuthenticationFilter
extends AbstractBasicAuthenticationFilter {
    private static final String APPLICATION_AUTHENTICATION_ERROR_MSG = "Application failed to authenticate";
    private static final Logger LOG = LoggerFactory.getLogger(BasicApplicationAuthenticationFilter.class);
    private final ApplicationManager applicationManager;
    private final ClientValidationManager clientValidationManager;

    public BasicApplicationAuthenticationFilter(ApplicationManager applicationManager, ClientValidationManager clientValidationManager) {
        this.applicationManager = applicationManager;
        this.clientValidationManager = clientValidationManager;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        this.ensureSeraphForwardsRequest(servletRequest);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AbstractBasicAuthenticationFilter.Credentials credentials = this.getBasicAuthCredentials(request);
        if (credentials == null) {
            LOG.debug("No basic auth credentials found in request, responding with authentication challenge");
            this.respondWithChallenge(response);
        } else {
            try {
                Application application = this.applicationManager.findByName(credentials.getName());
                this.clientValidationManager.validate(application, request);
                if (this.isAuthenticated(request, credentials)) {
                    LOG.debug("Application '{}' is already authenticated", (Object)credentials.getName());
                    chain.doFilter((ServletRequest)request, servletResponse);
                } else if (this.authenticate(application, credentials.getPassword())) {
                    LOG.debug("Application '{}' authenticated successfully", (Object)credentials.getName());
                    this.setAuthenticatedEntity(request, credentials.getName());
                    chain.doFilter((ServletRequest)request, servletResponse);
                } else {
                    LOG.info("Application '{}' failed authentication", (Object)credentials.getName());
                    this.respondWithChallenge(response);
                }
            }
            catch (ApplicationNotFoundException e) {
                LOG.info("Application '{}' failed authentication", (Object)credentials.getName());
                this.respondWithChallenge(response);
            }
            catch (ClientValidationException e) {
                response.sendError(403, e.getMessage());
            }
        }
    }

    private boolean authenticate(Application application, String password) throws ClientValidationException {
        try {
            return this.applicationManager.authenticate(application, PasswordCredential.unencrypted((String)password));
        }
        catch (ApplicationNotFoundException e) {
            LOG.info("Application with name '" + application.getName() + "' does not exist");
            return false;
        }
    }

    protected String getAuthenticatedEntity(HttpServletRequest request) {
        return AuthenticatedApplicationUtil.getAuthenticatedApplication(request);
    }

    protected void setAuthenticatedEntity(HttpServletRequest request, String name) {
        AuthenticatedApplicationUtil.setAuthenticatedApplication(request, name);
    }

    protected String getEntityAttributeKey() {
        return "com.atlassian.crowd.authenticated.application.name";
    }

    protected String getAuthenticationErrorMessage() {
        return APPLICATION_AUTHENTICATION_ERROR_MSG;
    }

    protected String getBasicRealm() {
        return "Crowd REST Service";
    }
}

