/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.util;

import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.plugin.rest.service.util.RestAuthSessionHelperUtil;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.Validate;

public class AuthenticatedApplicationUtil
extends RestAuthSessionHelperUtil {
    @VisibleForTesting
    public static final String APPLICATION_NAME_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.application.name";
    @VisibleForTesting
    public static final String APPLICATION_TOKEN_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.application.token";
    public static final int APPLICATION_SESSION_INACTIVE_INTERVAL_SECONDS = 60;

    private AuthenticatedApplicationUtil() {
    }

    private static HttpSession sessionWithTimeout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.setMaxInactiveInterval(60);
        return session;
    }

    @Nullable
    public static String getAuthenticatedApplication(HttpServletRequest request) {
        return AuthenticatedApplicationUtil.fetchStringFromRequestSession(request, APPLICATION_NAME_ATTRIBUTE_KEY);
    }

    public static void setAuthenticatedApplication(HttpServletRequest request, String applicationName) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)applicationName);
        AuthenticatedApplicationUtil.sessionWithTimeout(request).setAttribute(APPLICATION_NAME_ATTRIBUTE_KEY, (Object)applicationName);
    }

    @Nullable
    public static Token getAuthenticatedApplicationToken(HttpServletRequest request) {
        Validate.notNull((Object)request);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(APPLICATION_TOKEN_ATTRIBUTE_KEY);
        return value instanceof Token ? (Token)value : null;
    }

    public static void setAuthenticatedApplicationToken(HttpServletRequest request, Token token) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)token);
        AuthenticatedApplicationUtil.sessionWithTimeout(request).setAttribute(APPLICATION_TOKEN_ATTRIBUTE_KEY, (Object)token);
    }
}

