/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;

public class RestServiceVersionFilter
implements Filter {
    private static final String EMBEDDED_CROWD_VERSION_NAME = "X-Embedded-Crowd-Version";
    private final ApplicationProperties applicationProperties;
    private final Map<String, String> httpHeaders;
    private String applicationVersion;

    public RestServiceVersionFilter(ApplicationProperties applicationProperties) {
        Validate.notNull((Object)applicationProperties);
        this.applicationProperties = applicationProperties;
        this.httpHeaders = new HashMap<String, String>();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.applicationVersion = String.format("%s/%s", this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion());
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String headerName = (String)names.nextElement();
            this.httpHeaders.put(headerName, filterConfig.getInitParameter(headerName));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader(EMBEDDED_CROWD_VERSION_NAME, this.applicationVersion);
        for (Map.Entry<String, String> entry : this.httpHeaders.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        chain.doFilter(servletRequest, (ServletResponse)response);
    }

    public void destroy() {
    }
}

