/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.application;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.AliasAlreadyInUseException;
import com.atlassian.crowd.plugin.rest.service.controller.application.ApplicationController;
import com.atlassian.crowd.plugin.rest.util.SysAdminInterceptor;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="aliases")
@InterceptorChain(value={SysAdminInterceptor.class})
public class AliasResource {
    private final ApplicationController applicationController;

    public AliasResource(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @GET
    @Path(value="{applicationId}/alias")
    @Produces(value={"text/plain; charset=utf-8"})
    public String getAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username) throws ApplicationNotFoundException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        return this.applicationController.getAlias(applicationId, username);
    }

    @PUT
    @Path(value="{applicationId}/alias")
    @XsrfProtectionExcluded
    @Consumes(value={"text/plain"})
    public Response setAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username, String alias) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        this.applicationController.setAlias(applicationId, username, alias);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{applicationId}/alias")
    @XsrfProtectionExcluded
    public Response deleteAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        this.applicationController.deleteAlias(applicationId, username);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{applicationId}/username")
    @Produces(value={"text/plain; charset=utf-8"})
    public String getUsernameForAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="alias") String alias) throws ApplicationNotFoundException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)alias) ? 1 : 0) != 0);
        return this.applicationController.getUsernameForAlias(applicationId, alias);
    }

    @GET
    @Produces(value={"application/json"})
    public Map<Long, String> getAllAliasesForUserAsJson(@QueryParam(value="user") String username) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        return this.applicationController.getAliasesForUser(username);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response setAllAliasesForUser(@QueryParam(value="user") String username, Map<Long, String> aliasByApplication) throws AliasAlreadyInUseException {
        this.applicationController.setAliasesForUser(username, aliasByApplication);
        return Response.noContent().build();
    }

    @DELETE
    public Response deleteAllAliasesForUser(@QueryParam(value="user") String username) {
        this.applicationController.deleteAllAliasesForUser(username);
        return Response.noContent().build();
    }
}

