/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.account;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.plugin.rest.entity.PasswordChangeRequest;
import com.atlassian.crowd.plugin.rest.entity.PasswordResetRequest;
import com.atlassian.crowd.plugin.rest.entity.TokenValidEntity;
import com.atlassian.crowd.plugin.rest.entity.TokenValidRequest;
import com.atlassian.crowd.plugin.rest.service.controller.account.AccountManagementController;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="")
@AnonymousAllowed
public class AccountManagementResource {
    private final AccountManagementController accountManagementController;

    public AccountManagementResource(AccountManagementController accountManagementController) {
        this.accountManagementController = accountManagementController;
    }

    @POST
    @Path(value="change-password")
    @Consumes(value={"application/json"})
    public Response changePassword(PasswordChangeRequest request) {
        try {
            this.accountManagementController.changePassword(request.getUsername(), request.getOldPassword(), request.getNewPassword());
        }
        catch (Exception e) {
            return this.responseFromException(e);
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="reset-password")
    @Consumes(value={"application/json"})
    public Response resetPassword(PasswordResetRequest request) {
        try {
            this.accountManagementController.resetPassword(request.getUsername(), request.getDirectoryId(), request.getPassword(), request.getToken());
        }
        catch (Exception e) {
            return this.responseFromException(e);
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="token-status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TokenValidEntity validateToken(TokenValidRequest request) {
        boolean isValid = this.accountManagementController.isTokenValid(request.getDirectoryId(), request.getUsername(), request.getToken());
        boolean isUserActive = this.accountManagementController.isUserActive(request.getDirectoryId(), request.getUsername());
        return new TokenValidEntity(!isUserActive ? TokenValidEntity.TokenStatus.UNVERIFIED_SINCE_USER_DISABLED : (isValid ? TokenValidEntity.TokenStatus.VALID : TokenValidEntity.TokenStatus.INVALID));
    }

    @POST
    @Path(value="forgotten-password")
    @Consumes(value={"application/json"})
    public Response forgottenPassword(@QueryParam(value="username") String username) throws ApplicationPermissionException {
        this.accountManagementController.forgottenPassword(username);
        return Response.noContent().build();
    }

    @POST
    @Path(value="forgotten-username")
    @Consumes(value={"application/json"})
    public Response forgottenUsername(@QueryParam(value="email") String email) {
        this.accountManagementController.forgottenUsername(email);
        return Response.noContent().build();
    }

    protected Response responseFromException(Exception e) {
        ResetPasswordErrors error = ResetPasswordErrors.OTHER;
        String message = null;
        if (e instanceof OperationFailedException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if (e instanceof PermissionException) {
            error = ResetPasswordErrors.PERMISSION_ERROR;
        } else if (e instanceof InvalidCredentialException) {
            error = ResetPasswordErrors.PASSWORD_POLICY_VIOLATED;
            message = ((InvalidCredentialException)e).getPolicyDescription();
        } else if (e instanceof InvalidResetPasswordTokenException) {
            error = ResetPasswordErrors.INVALID_TOKEN;
        }
        ImmutableMap.Builder entity = new ImmutableMap.Builder().put((Object)"error", (Object)error);
        if (message != null) {
            entity.put((Object)"message", (Object)message);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity.build()).build();
    }

    public static enum ResetPasswordErrors {
        PERMISSION_ERROR,
        PASSWORD_POLICY_VIOLATED,
        INVALID_TOKEN,
        OTHER;

    }
}

