/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller.account;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.login.AsyncForgottenLoginManager;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AccountManagementController {
    private final ApplicationFactory crowdApplicationFactory;
    private final ApplicationService applicationService;
    private final ForgottenLoginManager forgottenLoginManager;
    private final AsyncForgottenLoginManager asyncForgottenLoginManager;

    @Inject
    public AccountManagementController(@ComponentImport ApplicationFactory crowdApplicationFactory, @ComponentImport ApplicationService applicationService, @ComponentImport ForgottenLoginManager forgottenLoginManager, @ComponentImport AsyncForgottenLoginManager asyncForgottenLoginManager) {
        this.crowdApplicationFactory = crowdApplicationFactory;
        this.applicationService = applicationService;
        this.forgottenLoginManager = forgottenLoginManager;
        this.asyncForgottenLoginManager = asyncForgottenLoginManager;
    }

    public void changePassword(String username, String originalPassword, String newPassword) throws UserNotFoundException, InvalidCredentialException, ApplicationPermissionException, OperationFailedException, InactiveAccountException, InvalidAuthenticationException {
        Application crowdApplication = this.crowdApplicationFactory.getApplication();
        try {
            this.applicationService.authenticateUser(crowdApplication, username, new PasswordCredential(originalPassword));
        }
        catch (ExpiredCredentialException expiredCredentialException) {
            // empty catch block
        }
        this.applicationService.updateUserCredential(crowdApplication, username, new PasswordCredential(newPassword));
    }

    public void resetPassword(String username, long directoryId, String password, String token) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, InvalidCredentialException, InvalidResetPasswordTokenException, OperationFailedException {
        this.forgottenLoginManager.resetUserCredential(directoryId, username, PasswordCredential.unencrypted((String)password), token);
    }

    public void forgottenPassword(String username) {
        this.asyncForgottenLoginManager.sendResetLink(username, ForgottenLoginManager.DEFAULT_TOKEN_EXPIRY_SECONDS);
    }

    public void forgottenUsername(String email) {
        this.asyncForgottenLoginManager.sendUsernames(email);
    }

    public boolean isTokenValid(long directoryId, String username, String token) {
        return this.forgottenLoginManager.isValidResetToken(directoryId, username, token);
    }

    public boolean isUserActive(long directoryId, String username) {
        return this.forgottenLoginManager.isUserActive(directoryId, username);
    }
}

