/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntity;
import com.atlassian.crowd.plugin.rest.service.controller.ApplicationController;
import com.atlassian.crowd.plugin.rest.util.ApplicationLinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="application")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@AnonymousAllowed
public class ApplicationResource {
    public static final String APPLICATION_NAME_QUERY_PARAM = "name";
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpServletRequest request;
    private final ApplicationController applicationController;

    public ApplicationResource(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @GET
    public Response getApplications(@QueryParam(value="name") String applicationName) throws ApplicationNotFoundException {
        if (applicationName == null) {
            return Response.ok((Object)this.applicationController.getAllApplications(this.uriInfo.getBaseUri())).build();
        }
        return Response.ok((Object)this.applicationController.getApplicationByName(applicationName, this.uriInfo.getBaseUri())).build();
    }

    @GET
    @Path(value="{applicationId}")
    public Response getApplicationById(@PathParam(value="applicationId") long applicationId) throws ApplicationNotFoundException {
        return Response.ok((Object)this.applicationController.getApplicationById(applicationId, this.uriInfo.getBaseUri())).build();
    }

    @POST
    public Response addApplication(@DefaultValue(value="false") @QueryParam(value="include-request-address") boolean includeRequestAddress, ApplicationEntity applicationEntity) throws DirectoryNotFoundException, InvalidCredentialException {
        Link link = includeRequestAddress ? this.applicationController.addApplicationWithRequestAddress(applicationEntity, this.request, this.uriInfo.getBaseUri()) : this.applicationController.addApplication(applicationEntity, this.uriInfo.getBaseUri());
        return Response.created((URI)link.getHref()).build();
    }

    @DELETE
    @Path(value="{applicationId}")
    public Response removeApplication(@PathParam(value="applicationId") long applicationId) throws ApplicationManagerException {
        this.applicationController.removeApplication(applicationId);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="{applicationId}")
    public Response updateApplication(@PathParam(value="applicationId") long applicationId, ApplicationEntity applicationEntity) throws ApplicationNotFoundException, DirectoryNotFoundException, ApplicationManagerException {
        if (applicationEntity.getId() == null || !applicationEntity.getId().equals(applicationId)) {
            throw new IllegalArgumentException("The application ID of the resource location <" + this.uriInfo.getPath() + "> and the application entity passed in <" + applicationEntity.getId() + "> are not equal");
        }
        this.applicationController.updateApplication(applicationEntity);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{applicationId}/remote_address")
    public Response getRemoteAddresses(@PathParam(value="applicationId") long applicationId) throws ApplicationNotFoundException {
        ApplicationEntity applicationEntity = this.applicationController.getApplicationById(applicationId, this.uriInfo.getBaseUri());
        return Response.ok((Object)applicationEntity.getRemoteAddresses()).build();
    }

    @POST
    @Path(value="{applicationId}/remote_address")
    public Response addRemoteAddress(@PathParam(value="applicationId") long applicationId, RemoteAddressEntity remoteAddressEntity) throws ApplicationNotFoundException, DirectoryNotFoundException, ApplicationManagerException {
        this.applicationController.addRemoteAddress(applicationId, remoteAddressEntity);
        return Response.created((URI)ApplicationLinkUriHelper.buildRemoteAddressUri(this.uriInfo.getBaseUri(), applicationId, remoteAddressEntity.getValue())).build();
    }

    @DELETE
    @Path(value="{applicationId}/remote_address")
    public Response removeRemoteAddress(@PathParam(value="applicationId") long applicationId, @QueryParam(value="address") String remoteAddress) throws ApplicationNotFoundException, DirectoryNotFoundException, ApplicationManagerException {
        this.applicationController.removeRemoteAddress(applicationId, remoteAddress);
        return Response.noContent().build();
    }
}

