/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.crowd.plugin.rest.filter.AbstractBasicAuthenticationFilter;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUserAuthenticationFilter
extends AbstractBasicAuthenticationFilter {
    private static final String USER_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.user.name";
    private static final String USER_AUTHENTICATION_ERROR_MSG = "User failed to authenticate";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicUserAuthenticationFilter.class);
    private final UserManager userManager;

    public BasicUserAuthenticationFilter(UserManager userManager) {
        this.userManager = userManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        this.ensureSeraphForwardsRequest(servletRequest);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AbstractBasicAuthenticationFilter.Credentials credentials = this.getBasicAuthCredentials(request);
        if (credentials == null) {
            LOGGER.debug("No basic auth credentials found in request, responding with authentication challenge");
            this.respondWithChallenge(response);
        } else if (this.isAuthenticated(request, credentials)) {
            LOGGER.debug("User '{}' is already authenticated", (Object)credentials.getName());
            chain.doFilter((ServletRequest)request, servletResponse);
        } else if (this.authenticate(credentials.getName(), credentials.getPassword())) {
            LOGGER.debug("User '{}' authenticated successfully", (Object)credentials.getName());
            this.setAuthenticatedEntity(request, credentials.getName());
            chain.doFilter((ServletRequest)request, servletResponse);
        } else {
            LOGGER.info("User '{}' failed authentication", (Object)credentials.getName());
            this.respondWithChallenge(response);
        }
    }

    private boolean authenticate(String username, String password) {
        boolean success;
        boolean bl = success = this.userManager.authenticate(username, password) && this.userManager.isAdmin(username);
        if (success) {
            LOGGER.debug("User {} was successfully authenticated.", (Object)username);
        } else {
            LOGGER.debug("User {} was unsuccessfully authenticated", (Object)username);
        }
        return success;
    }

    protected String getEntityAttributeKey() {
        return USER_ATTRIBUTE_KEY;
    }

    protected String getAuthenticationErrorMessage() {
        return USER_AUTHENTICATION_ERROR_MSG;
    }

    protected String getBasicRealm() {
        return "Crowd REST Application Management Service";
    }
}

