// $ANTLR 3.4 com/atlassian/crowd/cql/parser/antlr/CqlEval.g 2022-02-01 18:10:59

package com.atlassian.crowd.cql.parser.antlr;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.query.entity.PropertyTypeService;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;

import org.joda.time.format.ISODateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class CqlEval extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "AMPER", "AMPER_AMPER", "AND", "BANG", "BSLASH", "COMMA", "CONTROLCHARS", "CR", "DIGIT", "EQUALS", "ESCAPE", "ESC_SEQ", "EXPONENT", "GT", "HEXDIGIT", "HEX_DIGIT", "LBRACKET", "LPAREN", "LT", "MATCHWS", "MINUS", "NEWLINE", "NL", "OCTAL_ESC", "OR", "PIPE", "PIPE_PIPE", "QUOTE", "QUOTE_STRING", "RBRACKET", "RPAREN", "SPACE", "SQUOTE", "SQUOTE_STRING", "STRING", "STRINGSTOP", "UNARY_NULL_OPERATOR", "UNARY_OP_SEPARATOR", "UNICODE_ESC", "WS"
    };

    public static final int EOF=-1;
    public static final int AMPER=4;
    public static final int AMPER_AMPER=5;
    public static final int AND=6;
    public static final int BANG=7;
    public static final int BSLASH=8;
    public static final int COMMA=9;
    public static final int CONTROLCHARS=10;
    public static final int CR=11;
    public static final int DIGIT=12;
    public static final int EQUALS=13;
    public static final int ESCAPE=14;
    public static final int ESC_SEQ=15;
    public static final int EXPONENT=16;
    public static final int GT=17;
    public static final int HEXDIGIT=18;
    public static final int HEX_DIGIT=19;
    public static final int LBRACKET=20;
    public static final int LPAREN=21;
    public static final int LT=22;
    public static final int MATCHWS=23;
    public static final int MINUS=24;
    public static final int NEWLINE=25;
    public static final int NL=26;
    public static final int OCTAL_ESC=27;
    public static final int OR=28;
    public static final int PIPE=29;
    public static final int PIPE_PIPE=30;
    public static final int QUOTE=31;
    public static final int QUOTE_STRING=32;
    public static final int RBRACKET=33;
    public static final int RPAREN=34;
    public static final int SPACE=35;
    public static final int SQUOTE=36;
    public static final int SQUOTE_STRING=37;
    public static final int STRING=38;
    public static final int STRINGSTOP=39;
    public static final int UNARY_NULL_OPERATOR=40;
    public static final int UNARY_OP_SEPARATOR=41;
    public static final int UNICODE_ESC=42;
    public static final int WS=43;

    // delegates
    public TreeParser[] getDelegates() {
        return new TreeParser[] {};
    }

    // delegators


    public CqlEval(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }
    public CqlEval(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public String[] getTokenNames() { return CqlEval.tokenNames; }
    public String getGrammarFileName() { return "com/atlassian/crowd/cql/parser/antlr/CqlEval.g"; }



    private enum SimpleMatchMode { EQUALITY, GREATER_THAN, LESS_THAN, NULL };

    private PropertyTypeService propertyTypeService;

    public void setPropertyTypeService(final PropertyTypeService propertyTypeService)
    {
        this.propertyTypeService = propertyTypeService;
    }

    private PropertyRestriction createPropertyRestriction(final String propertyName, final SimpleMatchMode simpleMatchMode, final String value)
    {
        final Class clazz = propertyTypeService.getType(propertyName);
        if (clazz == null)
        {
            throw new IllegalArgumentException("Unknown type for property: " + propertyName);
        }
        final MatchMode mode = getMatchMode(simpleMatchMode, value);
        if (value == null && mode != MatchMode.NULL)
        {
            throw new IllegalArgumentException("value cannot be null unless match mode is null");
        }
        try
        {
            if (clazz.equals(String.class))
            {
                Property<String> property = new PropertyImpl<String>(propertyName, String.class);
                final String val = org.apache.commons.lang3.StringUtils.strip(value, "*");
                return new TermRestriction<String>(property, mode, val);
            }
            else if (clazz.equals(Integer.class))
            {
                Property<Integer> property = new PropertyImpl<Integer>(propertyName, Integer.class);
                return new TermRestriction<Integer>(property, mode, Integer.valueOf(value));
            }
            else if (clazz.equals(Float.class))
            {
                Property<Float> property = new PropertyImpl<Float>(propertyName, Float.class);
                return new TermRestriction<Float>(property, mode, Float.valueOf(value));
            }
            else if (clazz.equals(Date.class))
            {
                Property<Date> property = new PropertyImpl<Date>(propertyName, Date.class);
                org.joda.time.format.DateTimeFormatter formatter = ISODateTimeFormat.dateOptionalTimeParser();
                return new TermRestriction<Date>(property, mode, formatter.parseDateTime(value).toDate());
            }
            else if (clazz.equals(Boolean.class))
            {
                Property<Boolean> property = new PropertyImpl<Boolean>(propertyName, Boolean.class);
                return new TermRestriction<Boolean>(property, mode, Boolean.valueOf(value));
            }
        }
        catch (ClassCastException e)
        {
            throw new IllegalArgumentException("Unexpected type: " + e.getMessage());
        }
        throw new IllegalArgumentException("Unknown value type: " + clazz.getName());
    }

    private static MatchMode getMatchMode(final SimpleMatchMode mode, final String value)
    {
        switch (mode)
        {
        case EQUALITY:
            if (org.apache.commons.lang3.StringUtils.isNotBlank(value))
            {
                char firstChar = value.charAt(0);
                char lastChar = value.charAt(value.length() - 1);
                if (firstChar == '*' && lastChar == '*')
                {
                    return MatchMode.CONTAINS;
                }
                else if (lastChar == '*')
                {
                    return MatchMode.STARTS_WITH;
                }
            }
            return MatchMode.EXACTLY_MATCHES;
        case GREATER_THAN:
            return MatchMode.GREATER_THAN;
        case LESS_THAN:
            return MatchMode.LESS_THAN;
        case NULL:
            return MatchMode.NULL;
        default:
            throw new IllegalArgumentException("Unknown mode: " + mode);
        }
    }

    private static String stripQuotes(final String str)
    {
        return org.apache.commons.lang3.StringUtils.strip(str, "\"\'");
    }

    private static String unescape(String str)
    {
        return org.apache.commons.lang3.StringEscapeUtils.unescapeJava(str);
    }




    // $ANTLR start "getRestriction"
    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:129:1: getRestriction returns [SearchRestriction value] : a= restriction ;
    public final SearchRestriction getRestriction() throws RecognitionException {
        SearchRestriction value = null;


        SearchRestriction a =null;


        try {
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:130:2: (a= restriction )
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:130:4: a= restriction
            {
            pushFollow(FOLLOW_restriction_in_getRestriction49);
            a=restriction();

            state._fsp--;


            value = a;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return value;
    }
    // $ANTLR end "getRestriction"



    // $ANTLR start "restriction"
    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:133:1: restriction returns [SearchRestriction value] : ( ^( OR (res= restriction )+ ) | ^( AND (res= restriction )+ ) |res= propertyExpression );
    public final SearchRestriction restriction() throws RecognitionException {
        SearchRestriction value = null;


        SearchRestriction res =null;


        final List<SearchRestriction> reslist = new ArrayList<SearchRestriction>();
        try {
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:135:2: ( ^( OR (res= restriction )+ ) | ^( AND (res= restriction )+ ) |res= propertyExpression )
            int alt3=3;
            switch ( input.LA(1) ) {
            case OR:
                {
                alt3=1;
                }
                break;
            case AND:
                {
                alt3=2;
                }
                break;
            case EQUALS:
            case GT:
            case LT:
            case UNARY_NULL_OPERATOR:
                {
                alt3=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:135:4: ^( OR (res= restriction )+ )
                    {
                    match(input,OR,FOLLOW_OR_in_restriction72); 

                    match(input, Token.DOWN, null); 
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:135:9: (res= restriction )+
                    int cnt1=0;
                    loop1:
                    do {
                        int alt1=2;
                        switch ( input.LA(1) ) {
                        case AND:
                        case EQUALS:
                        case GT:
                        case LT:
                        case OR:
                        case UNARY_NULL_OPERATOR:
                            {
                            alt1=1;
                            }
                            break;

                        }

                        switch (alt1) {
                    	case 1 :
                    	    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:135:10: res= restriction
                    	    {
                    	    pushFollow(FOLLOW_restriction_in_restriction77);
                    	    res=restriction();

                    	    state._fsp--;


                    	     reslist.add(res); 

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt1 >= 1 ) break loop1;
                                EarlyExitException eee =
                                    new EarlyExitException(1, input);
                                throw eee;
                        }
                        cnt1++;
                    } while (true);


                    match(input, Token.UP, null); 


                    value = Combine.anyOf(reslist);

                    }
                    break;
                case 2 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:136:4: ^( AND (res= restriction )+ )
                    {
                    match(input,AND,FOLLOW_AND_in_restriction90); 

                    match(input, Token.DOWN, null); 
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:136:10: (res= restriction )+
                    int cnt2=0;
                    loop2:
                    do {
                        int alt2=2;
                        switch ( input.LA(1) ) {
                        case AND:
                        case EQUALS:
                        case GT:
                        case LT:
                        case OR:
                        case UNARY_NULL_OPERATOR:
                            {
                            alt2=1;
                            }
                            break;

                        }

                        switch (alt2) {
                    	case 1 :
                    	    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:136:11: res= restriction
                    	    {
                    	    pushFollow(FOLLOW_restriction_in_restriction95);
                    	    res=restriction();

                    	    state._fsp--;


                    	     reslist.add(res); 

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt2 >= 1 ) break loop2;
                                EarlyExitException eee =
                                    new EarlyExitException(2, input);
                                throw eee;
                        }
                        cnt2++;
                    } while (true);


                    match(input, Token.UP, null); 


                    value = Combine.allOf(reslist);

                    }
                    break;
                case 3 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:137:4: res= propertyExpression
                    {
                    pushFollow(FOLLOW_propertyExpression_in_restriction109);
                    res=propertyExpression();

                    state._fsp--;


                    value = res;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return value;
    }
    // $ANTLR end "restriction"



    // $ANTLR start "propertyExpression"
    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:140:1: propertyExpression returns [SearchRestriction value] : ( ^(op= comparison_op key= termKey val= termValue ) | ^( UNARY_NULL_OPERATOR key= termKey ) );
    public final SearchRestriction propertyExpression() throws RecognitionException {
        SearchRestriction value = null;


        SimpleMatchMode op =null;

        String key =null;

        String val =null;


        try {
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:141:2: ( ^(op= comparison_op key= termKey val= termValue ) | ^( UNARY_NULL_OPERATOR key= termKey ) )
            int alt4=2;
            switch ( input.LA(1) ) {
            case EQUALS:
            case GT:
            case LT:
                {
                alt4=1;
                }
                break;
            case UNARY_NULL_OPERATOR:
                {
                alt4=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:141:4: ^(op= comparison_op key= termKey val= termValue )
                    {
                    pushFollow(FOLLOW_comparison_op_in_propertyExpression129);
                    op=comparison_op();

                    state._fsp--;


                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_termKey_in_propertyExpression133);
                    key=termKey();

                    state._fsp--;


                    pushFollow(FOLLOW_termValue_in_propertyExpression137);
                    val=termValue();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    value = createPropertyRestriction(key, op, val);

                    }
                    break;
                case 2 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:142:4: ^( UNARY_NULL_OPERATOR key= termKey )
                    {
                    match(input,UNARY_NULL_OPERATOR,FOLLOW_UNARY_NULL_OPERATOR_in_propertyExpression146); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_termKey_in_propertyExpression150);
                    key=termKey();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    value = createPropertyRestriction(key, SimpleMatchMode.NULL, null);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return value;
    }
    // $ANTLR end "propertyExpression"



    // $ANTLR start "termKey"
    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:145:1: termKey returns [String value] : ( STRING | QUOTE_STRING | SQUOTE_STRING );
    public final String termKey() throws RecognitionException {
        String value = null;


        CommonTree STRING1=null;
        CommonTree QUOTE_STRING2=null;
        CommonTree SQUOTE_STRING3=null;

        try {
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:146:2: ( STRING | QUOTE_STRING | SQUOTE_STRING )
            int alt5=3;
            switch ( input.LA(1) ) {
            case STRING:
                {
                alt5=1;
                }
                break;
            case QUOTE_STRING:
                {
                alt5=2;
                }
                break;
            case SQUOTE_STRING:
                {
                alt5=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;

            }

            switch (alt5) {
                case 1 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:146:4: STRING
                    {
                    STRING1=(CommonTree)match(input,STRING,FOLLOW_STRING_in_termKey168); 

                    value = unescape((STRING1!=null?STRING1.getText():null));

                    }
                    break;
                case 2 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:147:4: QUOTE_STRING
                    {
                    QUOTE_STRING2=(CommonTree)match(input,QUOTE_STRING,FOLLOW_QUOTE_STRING_in_termKey175); 

                    value = unescape(stripQuotes((QUOTE_STRING2!=null?QUOTE_STRING2.getText():null)));

                    }
                    break;
                case 3 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:148:4: SQUOTE_STRING
                    {
                    SQUOTE_STRING3=(CommonTree)match(input,SQUOTE_STRING,FOLLOW_SQUOTE_STRING_in_termKey182); 

                    value = unescape(stripQuotes((SQUOTE_STRING3!=null?SQUOTE_STRING3.getText():null)));

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return value;
    }
    // $ANTLR end "termKey"



    // $ANTLR start "termValue"
    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:151:1: termValue returns [String value] : ( STRING | QUOTE_STRING | SQUOTE_STRING );
    public final String termValue() throws RecognitionException {
        String value = null;


        CommonTree STRING4=null;
        CommonTree QUOTE_STRING5=null;
        CommonTree SQUOTE_STRING6=null;

        try {
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:152:2: ( STRING | QUOTE_STRING | SQUOTE_STRING )
            int alt6=3;
            switch ( input.LA(1) ) {
            case STRING:
                {
                alt6=1;
                }
                break;
            case QUOTE_STRING:
                {
                alt6=2;
                }
                break;
            case SQUOTE_STRING:
                {
                alt6=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:152:4: STRING
                    {
                    STRING4=(CommonTree)match(input,STRING,FOLLOW_STRING_in_termValue199); 

                    value = unescape((STRING4!=null?STRING4.getText():null));

                    }
                    break;
                case 2 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:153:4: QUOTE_STRING
                    {
                    QUOTE_STRING5=(CommonTree)match(input,QUOTE_STRING,FOLLOW_QUOTE_STRING_in_termValue206); 

                    value = unescape(stripQuotes((QUOTE_STRING5!=null?QUOTE_STRING5.getText():null)));

                    }
                    break;
                case 3 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:154:4: SQUOTE_STRING
                    {
                    SQUOTE_STRING6=(CommonTree)match(input,SQUOTE_STRING,FOLLOW_SQUOTE_STRING_in_termValue213); 

                    value = unescape(stripQuotes((SQUOTE_STRING6!=null?SQUOTE_STRING6.getText():null)));

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return value;
    }
    // $ANTLR end "termValue"



    // $ANTLR start "comparison_op"
    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:157:1: comparison_op returns [SimpleMatchMode value] : ( EQUALS | LT | GT );
    public final SimpleMatchMode comparison_op() throws RecognitionException {
        SimpleMatchMode value = null;


        try {
            // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:158:2: ( EQUALS | LT | GT )
            int alt7=3;
            switch ( input.LA(1) ) {
            case EQUALS:
                {
                alt7=1;
                }
                break;
            case LT:
                {
                alt7=2;
                }
                break;
            case GT:
                {
                alt7=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;

            }

            switch (alt7) {
                case 1 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:158:4: EQUALS
                    {
                    match(input,EQUALS,FOLLOW_EQUALS_in_comparison_op230); 

                    value = SimpleMatchMode.EQUALITY;

                    }
                    break;
                case 2 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:159:4: LT
                    {
                    match(input,LT,FOLLOW_LT_in_comparison_op237); 

                    value = SimpleMatchMode.LESS_THAN;

                    }
                    break;
                case 3 :
                    // com/atlassian/crowd/cql/parser/antlr/CqlEval.g:160:4: GT
                    {
                    match(input,GT,FOLLOW_GT_in_comparison_op244); 

                    value = SimpleMatchMode.GREATER_THAN;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return value;
    }
    // $ANTLR end "comparison_op"

    // Delegated rules


 

    public static final BitSet FOLLOW_restriction_in_getRestriction49 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OR_in_restriction72 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_restriction_in_restriction77 = new BitSet(new long[]{0x0000010010422048L});
    public static final BitSet FOLLOW_AND_in_restriction90 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_restriction_in_restriction95 = new BitSet(new long[]{0x0000010010422048L});
    public static final BitSet FOLLOW_propertyExpression_in_restriction109 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_comparison_op_in_propertyExpression129 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_termKey_in_propertyExpression133 = new BitSet(new long[]{0x0000006100000000L});
    public static final BitSet FOLLOW_termValue_in_propertyExpression137 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNARY_NULL_OPERATOR_in_propertyExpression146 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_termKey_in_propertyExpression150 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_STRING_in_termKey168 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTE_STRING_in_termKey175 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SQUOTE_STRING_in_termKey182 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_termValue199 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTE_STRING_in_termValue206 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SQUOTE_STRING_in_termValue213 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EQUALS_in_comparison_op230 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LT_in_comparison_op237 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GT_in_comparison_op244 = new BitSet(new long[]{0x0000000000000002L});

}