/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.query.entity;

import com.atlassian.crowd.search.query.entity.PropertyTypeService;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTypeServiceImpl
implements PropertyTypeService {
    private static final Logger logger = LoggerFactory.getLogger(PropertyTypeServiceImpl.class);
    private final Map<String, Class> propertyTypeMap;

    public PropertyTypeServiceImpl(Map<String, Class> propertyTypeMap) {
        this.propertyTypeMap = ImmutableMap.copyOf(propertyTypeMap);
    }

    @Override
    public Class<?> getType(String name) {
        Class propertyType = this.propertyTypeMap.get(name);
        if (propertyType != null) {
            return propertyType;
        }
        logger.debug("Unknown property '{}', assuming it's a custom attr of type String", (Object)name);
        return String.class;
    }

    public static PropertyTypeServiceImpl newInstance(Iterable<Property<?>> properties) {
        HashMap propertyTypeMap = Maps.newHashMap();
        for (Property<?> property : properties) {
            propertyTypeMap.put(property.getPropertyName(), property.getPropertyType());
        }
        return new PropertyTypeServiceImpl(propertyTypeMap);
    }
}

