package com.atlassian.crowd.search.hibernate.audit;

import com.atlassian.crowd.search.hibernate.HQLQuery;

public class RestrictionWithJoin implements Restriction {
    private final String join;
    private final Restriction restriction;

    public RestrictionWithJoin(String join, Restriction restriction) {
        this.join = join;
        this.restriction = restriction;
    }

    @Override
    public String getWhere(HQLQuery hqlQuery) {
        return restriction.getWhere(hqlQuery);
    }

    @Override
    public String getFrom() {
        return " " + join;
    }
}
