package com.atlassian.crowd.search.hibernate;

import java.util.List;
import java.util.function.Function;

/**
 * Helper interface for fetching custom data types from hibernate queries.
 */
interface CustomDataFetcher<T> {
    /**
     * @param alias alias for the entity
     * @return list of entity attributes that need to be selected
     */
    List<String> attributes(String alias);

    /**
     * Returns transformer that will create custom data type from attributes values. Returned transformer should be only
     * used within a scope of a single hibernate session.
     *
     * @param start index of the value matching first attribute
     * @return transformer producing entity from provided values; order of the values must correspond to the
     * order of attributes from {@link #attributes(String)}
     */
    Function<Object[], T> getTransformer(int start);
}
