package com.atlassian.crowd.model.user;

import java.util.Objects;

import com.atlassian.crowd.model.DirectoryEntity;

public class MinimalUser implements DirectoryEntity {

    private final String name;
    private final long id;
    private final long directoryId;

    public MinimalUser(long id, long directoryId, String name) {
        this.name = name;
        this.id = id;
        this.directoryId = directoryId;
    }

    @Override
    public long getDirectoryId() {
        return directoryId;
    }

    @Override
    public String getName() {
        return name;
    }

    public long getId() {
        return id;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        final MinimalUser that = (MinimalUser) obj;
        return id == that.id
                && directoryId == that.directoryId
                && Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, directoryId, name);
    }
}
