package com.atlassian.crowd.model.tombstone;

import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.MoreObjects;

public class UserTombstone extends AbstractTombstone {
    private String name;
    private long directoryId;

    protected UserTombstone() {

    }

    public UserTombstone(long timestamp, String name, long directoryId) {
        super(timestamp);
        this.name = name;
        this.directoryId = directoryId;
    }

    public String getName() {
        return name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public long getDirectoryId() {
        return directoryId;
    }

    protected void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    public User toUser() {
        return new ImmutableUser(getDirectoryId(), getName(), null, null, false, null, null, null);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("name", name)
                .add("directoryId", directoryId)
                .toString();
    }
}