package com.atlassian.crowd.model.tombstone;

import com.google.common.base.MoreObjects;

public class MembershipTombstone extends AbstractTombstone {
    private String childName;
    private String parentName;
    private long directoryId;

    protected MembershipTombstone() {
    }

    protected MembershipTombstone(long timestamp, String childName, String parentName, long directoryId) {
        super(timestamp);
        this.childName = childName;
        this.parentName = parentName;
        this.directoryId = directoryId;
    }

    public String getChildName() {
        return childName;
    }

    protected void setChildName(String childName) {
        this.childName = childName;
    }

    public String getParentName() {
        return parentName;
    }

    protected void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public long getDirectoryId() {
        return directoryId;
    }

    protected void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("childName", childName)
                .add("parentName", parentName)
                .add("directoryId", directoryId)
                .toString();
    }
}