package com.atlassian.crowd.model.permission;

import com.atlassian.crowd.model.group.InternalGroup;
import com.google.common.base.MoreObjects;

import java.util.Objects;

public class GroupAdministrationGrantToGroup {
    private Long id;
    private InternalGroup group;
    private InternalGroup targetGroup;

    public GroupAdministrationGrantToGroup() {
    }

    public GroupAdministrationGrantToGroup(InternalGroup group, InternalGroup targetGroup) {
        this.group = group;
        this.targetGroup = targetGroup;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public InternalGroup getGroup() {
        return group;
    }

    public void setGroup(InternalGroup group) {
        this.group = group;
    }

    public InternalGroup getTargetGroup() {
        return targetGroup;
    }

    public void setTargetGroup(InternalGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupAdministrationGrantToGroup that = (GroupAdministrationGrantToGroup) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(group, that.group) &&
                Objects.equals(targetGroup, that.targetGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, group, targetGroup);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("group", group)
                .add("targetGroup", targetGroup)
                .toString();
    }
}
