package com.atlassian.crowd.model.licensing;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Objects;

/**
 * User that is consuming license in product.
 */
public class LicensedUser {
    private Long id;
    private String username;
    private Date lastActive;
    private String fullName;
    private String email;
    private DirectoryInfo directory;

    // for indexing and searching
    private String lowerUsername;
    private String lowerFullName;
    private String lowerEmail;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.lowerUsername = IdentifierUtils.toLowerCase(username);
    }

    public Date getLastActive() {
        return lastActive;
    }

    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.lowerFullName = StringUtils.lowerCase(fullName);
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.lowerEmail = StringUtils.lowerCase(email);
    }

    public DirectoryInfo getDirectory() {
        return directory;
    }

    public void setDirectory(DirectoryInfo directory) {
        this.directory = directory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LicensedUser user = (LicensedUser) o;
        return Objects.equals(id, user.id) &&
                Objects.equals(username, user.username) &&
                Objects.equals(lastActive, user.lastActive) &&
                Objects.equals(fullName, user.fullName) &&
                Objects.equals(email, user.email) &&
                Objects.equals(directory, user.directory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, username, lastActive, fullName, email, directory);
    }
}
