package com.atlassian.crowd.model.licensing;

import com.atlassian.crowd.embedded.api.Directory;

import java.util.Objects;

/**
 * Directory information for users that are consuming licenses in the product.
 */
public class DirectoryInfo {
    private Long id;
    private String name;
    private Directory localDirectory;
    private LicensingSummary licensingSummary;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Directory getLocalDirectory() {
        return localDirectory;
    }

    public void setLocalDirectory(Directory localDirectory) {
        this.localDirectory = localDirectory;
    }

    public LicensingSummary getLicensingSummary() {
        return licensingSummary;
    }

    public void setLicensingSummary(LicensingSummary licensingSummary) {
        this.licensingSummary = licensingSummary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DirectoryInfo that = (DirectoryInfo) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                Objects.equals(localDirectory, that.localDirectory) &&
                Objects.equals(licensingSummary, that.licensingSummary);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, localDirectory, licensingSummary);
    }
}
